/*
 * Decompiled with CFR 0.152.
 */
package com.caenrfid.openjdk;

import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDNotify;
import com.caen.RFIDLibrary.CAENRFIDPort;
import com.caen.RFIDLibrary.CAENRFIDReader;
import com.caen.RFIDLibrary.CAENRFIDReaderInfo;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Hex;

public class OpenJDK {
    static int tagCounter = 0;

    public static void main(String[] args) throws CAENRFIDException, InterruptedException {
        CAENRFIDReader reader = new CAENRFIDReader();
        System.out.println("Start");
        reader.Connect(CAENRFIDPort.CAENRFID_TCP, "10.106.254.115");
        reader.SetPower(50);
        CAENRFIDReaderInfo info = reader.GetReaderInfo();
        System.out.println("Reader info -> Model is: " + info.GetModel() + " and serial number is: " + info.GetSerialNumber());
        reader.addCAENRFIDEventListener(evt -> {
            System.out.println("Tag n: " + ++tagCounter);
            ArrayList notifies = evt.getData();
            for (CAENRFIDNotify notify : notifies) {
                System.out.println("    Tag -> " + Hex.encodeHexString((byte[])notify.getTagID()));
            }
        });
        int rc = reader.GetSource("Source_0").GetReadCycle();
        reader.GetSource("Source_0").SetReadCycle(0);
        short flags = (short)(CAENRFIDLogicalSource.InventoryFlag.CONTINUOS.getValue() + CAENRFIDLogicalSource.InventoryFlag.FRAMED.getValue());
        reader.GetSource("Source_0").EventInventoryTag(new byte[12], (short)0, (short)0, flags);
        Thread.sleep(5000L);
        reader.InventoryAbort();
        reader.GetSource("Source_0").SetReadCycle(rc);
        reader.Disconnect();
        System.out.println("End");
    }
}

