/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDBitRate;
import com.caen.RFIDLibrary.CAENRFIDEvent;
import com.caen.RFIDLibrary.CAENRFIDEventListener;
import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDMatchingParams;
import com.caen.RFIDLibrary.CAENRFIDNetworkInfo;
import com.caen.RFIDLibrary.CAENRFIDNotify;
import com.caen.RFIDLibrary.CAENRFIDPort;
import com.caen.RFIDLibrary.CAENRFIDProtocol;
import com.caen.RFIDLibrary.CAENRFIDRFRegulations;
import com.caen.RFIDLibrary.CAENRFIDRS232Constants;
import com.caen.RFIDLibrary.CAENRFIDReadPointStatus;
import com.caen.RFIDLibrary.CAENRFIDReaderInfo;
import com.caen.RFIDLibrary.CAENRFIDSelUnselOptions;
import com.caen.RFIDLibrary.CAENRFIDTag;
import com.caen.RFIDLibrary.CAENRFIDTagEventType;
import com.caen.RFIDLibrary.CAENRFIDTag_NXP_UCODE8;
import com.caen.RFIDLibrary.EM4325TagData;
import com.caen.RFIDLibrary.IDSTagData;
import com.caen.RFIDLibrary.InventorySubCommand;
import com.caen.TCPPort.TCPPort;
import com.caen.TCPPort.TCPPortEvent;
import com.caen.TCPPort.TCPPortEventListener;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.event.EventListenerList;

public final class CAENRFIDReader {
    private final int INV_FLAG_B00_RSSI = 1;
    private final int INV_FLAG_B01_FRAMED = 2;
    private final int INV_FLAG_B02_CONTINUOUS = 4;
    private final int INV_FLAG_B03_COMPACT = 8;
    private final int INV_FLAG_B04_TID = 16;
    private final int INV_FLAG_B05_EVT_TRIGGER = 32;
    private final int INV_FLAG_B06_XPC = 64;
    private final int INV_FLAG_B07_OBS = 128;
    private final int INV_FLAG_B08_OBS_PC = 256;
    private final int INV_FLAG_B09_SW_TRIGGER = 512;
    private final int INV_FLAG_B10_RET_EVENTS = 1024;
    private final int INV_FLAG_B11_CLR_BUFFER = 2048;
    private final int INV_FLAG_B12_KEEP_ALIVE = 4096;
    private final int INV_FLAG_B13_PHASE = 8192;
    private final int INV_FLAG_B14_FREQUENCY = 16384;
    private final int INV_FLAG_B15_RESERVED = 32768;
    private final int INV_FLAG2_B00_SUBCMD = 1;
    private final int MASK_CONTINUOUS_FLAGS = 61785;
    private final int MASK_WPERS1170E13_FLAGS = 3584;
    private static final int SOURCES_X_READER = 4;
    private static final int HEADER_SIZE = 10;
    private static final int AVP_HEADERSIZE = 6;
    private static final int COMMAND_SIZE = 8;
    private static final int TIMEOUT = 1000;
    private static final int MAX_CHAR_DESCRIPTION = 256;
    private static final int MAX_READPOINT_NAME = 5;
    private static final int MAX_FIRMWARE_STRING = 200;
    private static final int HEADER_PID_BYTE_OFFSET = 2;
    private static final int XPC_LENGTH = 4;
    private static final int PC_LENGTH = 2;
    protected static final int MAX_ID_LENGTH = 2048;
    private static final short PROTO_ISO180006B = 0;
    private static final short PROTO_EPCC1G1 = 1;
    private static final short PROTO_ISO180006A = 2;
    private static final short PROTO_EPCC1G2 = 3;
    private static final short PROTO_MULTI = 4;
    private static final short PROTO_EPC119 = 5;
    private static final short RAWREADID_COMMAND = 18;
    private static final short NEWRAWREADID_COMMAND = 19;
    private static final short ADDREADTRIGGER_COMMAND = 63;
    private static final short ADDNOTIFYTRIGGER_COMMAND = 64;
    private static final short REMOVEREADTRIGGER_COMMAND = 65;
    private static final short REMOVENOTIFYTRIGGER_COMMAND = 66;
    private static final short ALLOCATETRIGGER_COMMAND = 73;
    private static final short DEALLOCATETRIGGER_COMMAND = 74;
    private static final short ALLOCATECHANNEL_COMMAND = 83;
    private static final short DEALLOCATECHANNEL_COMMAND = 84;
    private static final short ADDSOURCETOCHANNEL_COMMAND = 93;
    private static final short REMOVESOURCEFROMCHANNEL_COMMAND = 94;
    private static final short ADDREADPOINT_COMMAND = 95;
    private static final short REMOVEREADPOINT_COMMAND = 96;
    private static final short SETPOWER_COMMAND = 100;
    private static final short READTAG_COMMAND = 110;
    private static final short WRITETAG_COMMAND = 111;
    private static final short LOCKTAG_COMMAND = 112;
    private static final short SETMODULATION_COMMAND = 114;
    private static final short GETPOWER_COMMAND = 115;
    private static final short SETPROTOCOL_COMMAND = 116;
    private static final short CHECKREADPOINTSTATE = 118;
    private static final short CHECKSOURCEINCHANNEL_COMMAND = 119;
    private static final short CHECKREADPOINTINSOURCE_COMMAND = 120;
    private static final short GETPROTOCOL_COMMAND = 121;
    private static final short SETNETWORK_COMMAND = 122;
    private static final short DE_SBCTRL_COMMAND = 123;
    private static final short GETFWRELEASE_COMMAND = 124;
    private static final short GETEXBIT_COMMAND = 125;
    private static final short PROGRAMID_COMMAND = 126;
    private static final short KILLTAG_COMMAND = 127;
    private static final short RFONOFF_COMMAND = 128;
    private static final short GETMODULATION_COMMAND = 129;
    private static final short BLOCKWRITETAG_COMMAND = 130;
    private static final short SETRS232_COMMAND = 131;
    private static final short SETDATETIME_COMMAND = 132;
    private static final short GROUPSELUNSEL_COMMAND = 133;
    private static final short GETIO_COMMAND = 134;
    private static final short SETIO_COMMAND = 135;
    private static final short SETIODIRECTION_COMMAND = 136;
    private static final short GETIODIRECTION_COMMAND = 137;
    private static final short SETSOURCECONFIG_COMMAND = 138;
    private static final short GETSOURCECONFIG_COMMAND = 139;
    private static final short GETTRIGGERS_COMMAND = 140;
    private static final short GETCHANNELS_COMMAND = 141;
    private static final short CHECKSOURCEINTRIGGER_COMMAND = 142;
    private static final short CHECKCHANNELINTRIGGER_COMMAND = 144;
    private static final short CHECKTRIGGERINCHANNEL_COMMAND = 143;
    private static final short SETEVENTMODE_COMMAND = 145;
    private static final short GETEVENTMODE_COMMAND = 146;
    private static final short FIRMWAREUPGRADE_COMMAND = 147;
    private static final short EPC119PROGRAMID_COMMAND = 148;
    private static final short G2PROGRAMID_COMMAND = 149;
    protected static final short G2READTAG_COMMAND = 150;
    protected static final short G2WRITETAG_COMMAND = 151;
    private static final short G2LOCKTAG_COMMAND = 152;
    private static final short G2KILLTAG_COMMAND = 153;
    private static final short G2QUERYTAG_COMMAND = 154;
    private static final short G2SETQ_COMMAND = 155;
    private static final short G2GETQ_COMMAND = 156;
    private static final short G2QUERYACK_COMMAND = 157;
    private static final short GETREADERINFO_COMMAND = 158;
    private static final short SETLBTMODE_COMMAND = 159;
    private static final short GETLBTMODE_COMMAND = 160;
    private static final short SETRFREGULATION_COMMAND = 161;
    private static final short GETRFREGULATION_COMMAND = 162;
    private static final short SETCHANNEL_COMMAND = 163;
    private static final short GETCHANNEL_COMMAND = 164;
    private static final short RESETSESSION_COMMAND = 165;
    private static final short GETCHANNELDATA_COMMAND = 167;
    private static final short G2CUSTOMCMD_COMMAND = 168;
    private static final short GETCHANNELSTATUS_COMMAND = 169;
    private static final short SETREADEROPTIONS = 170;
    private static final short SETADMINPWD_COMMAND = 172;
    private static final short LOGIN_COMMAND = 173;
    private static final short LOGOUT_COMMAND = 174;
    private static final short GETBUFFEREDDATA_COMMAND = 176;
    private static final short G2LOCKBLOCKPERMABLOCK_COMMAND = 177;
    private static final short G2READBLOCKPERMABLOCK_COMMAND = 178;
    private static final short CMD_SAVE_SETTINGS_COMMAND = 179;
    private static final short MATCHRFIMPEDANCE_COMMAND = 180;
    private static final short PRINTSCREEN_COMMAND = 181;
    private static final short GETBATTERYLEVEL_COMMAND = 182;
    private static final short GETBUFFERSIZE_COMMAND = 183;
    private static final short CLEARBUFFER_COMMAND = 184;
    private static final short UNTRACEABLE_COMMAND = 185;
    private static final short AUTHENTICATE_COMMAND = 186;
    private static final short SETREADPOINTPOWER_COMMAND = 189;
    private static final short GETREADPOINTPOWER_COMMAND = 190;
    private static final short G2BLOCKWRITETAG_COMMAND = 191;
    private static final short G2BLOCKPROGRAMID_COMMAND = 192;
    private static final short GETNETWORK_COMMAND = 193;
    private static final short AVP_COMMAND = 1;
    private static final short AVP_RESULT = 2;
    private static final short AVP_EVENTTYPE = 14;
    private static final short AVP_TAGIDLENGTH = 15;
    private static final short AVP_TIMESTAMP = 16;
    private static final short AVP_TAGID = 17;
    private static final short AVP_TAGTYPE = 18;
    private static final short AVP_CHANNEL_NAME = 30;
    private static final short AVP_CHANNEL_ADDRESS = 31;
    private static final short AVP_TRIGGER_NAME = 32;
    private static final short AVP_TRIGGER_TYPE = 33;
    private static final short AVP_READPOINT_NAME = 34;
    private static final short AVP_TAG_VALUE = 77;
    private static final short AVP_TAGADDRESS = 78;
    private static final short AVP_LENGTH = 80;
    private static final short AVP_MODULATION = 81;
    private static final short AVP_GETPOWER = 82;
    private static final short AVP_VSWR = 83;
    private static final short AVP_PROTOCOL_NAME = 84;
    private static final short AVP_READPOINT_STATUS = 86;
    private static final short AVP_BOOLEAN = 87;
    private static final short AVP_IPADDRESS = 88;
    private static final short AVP_IPNETMASK = 89;
    private static final short AVP_IPGATEWAY = 90;
    private static final short AVP_DE_SBENA = 91;
    private static final short AVP_GETFWRELEASE = 92;
    private static final short AVP_EXBIT_STATUS = 93;
    private static final short AVP_EPCPWD = 94;
    private static final short AVP_RFONOFF = 95;
    private static final short AVP_BAUDRATE = 96;
    private static final short AVP_DATABIT = 97;
    private static final short AVP_STOPBITS = 98;
    private static final short AVP_PARITY = 99;
    private static final short AVP_FLOWCONTROL = 100;
    private static final short AVP_DATETIME = 101;
    private static final short AVP_SELUNSEL_OP = 102;
    private static final short AVP_BYTEMASK = 103;
    private static final short AVP_IOREGISTER = 105;
    private static final short AVP_CONFIGPARAMETER = 106;
    private static final short AVP_CONFIGVALUE = 107;
    private static final short AVP_NUMBEROFTRIGGERS = 108;
    private static final short AVP_NUMBEROFCHANNELS = 109;
    private static final short AVP_EVENTMODE = 110;
    private static final short AVP_UPGRADETYPE = 111;
    private static final short AVP_UPGRADEARG = 112;
    private static final short AVP_MEMBANK = 113;
    private static final short AVP_PAYLOAD = 114;
    private static final short AVP_G2PWD = 115;
    private static final short AVP_G2NSI = 116;
    private static final short AVP_G2Q = 117;
    private static final short AVP_READERINFO = 118;
    private static final short AVP_RF_REGULATION = 119;
    private static final short AVP_RFCHANNEL = 120;
    private static final short AVP_SUBCMD = 121;
    private static final short AVP_RSSI = 122;
    private static final short AVP_XPC = 124;
    private static final short AVP_PC = 125;
    private static final short AVP_PHASE = 126;
    private static final short AVP_TERMINAL_TYPE = 127;
    private static final short AVP_BATTERY_LEVEL = 128;
    private static final short AVP_LONG_LENGTH = 129;
    private static final short AVP_LONG_ADDRESS = 130;
    private static final short AVP_UINT16 = 131;
    private static final short AVP_FREQUENCY = 132;
    private static final short AVP_SETPOWER = 150;
    private static final short AVP_SOURCE_NAME = 251;
    protected static final int CONFIG_READCYCLE = 0;
    protected static final int CONFIG_OBSERVEDTHRESHOLD = 1;
    protected static final int CONFIG_LOSTTHRESHOLD = 2;
    protected static final int CONFIG_G2_Q_VALUE = 3;
    protected static final int CONFIG_G2_SESSION = 4;
    protected static final int CONFIG_G2_TARGET = 5;
    protected static final int CONFIG_G2_SELECTED = 6;
    protected static final int CONFIG_ISO18006B_DESB = 7;
    protected static final int CONFIG_DWELL_TIME = 8;
    protected static final int CONFIG_INV_COUNT = 10;
    protected static final int CONFIG_G2_Q_MIN = 11;
    protected static final int CONFIG_G2_Q_MAX = 12;
    protected static final int CONFIG_TID_LENGTH = 13;
    protected static final int CONFIG_QUIETTIME = 15;
    protected static final int CONFIG_G2_NUM_MIN_Q = 16;
    protected static final int CCODE_Hitachi_readLock = 0;
    protected static final int CCODE_Hitachi_WriteMultipleWords = 1;
    protected static final int CCODE_Hitachi_BlockLock = 2;
    protected static final int CCODE_Hitachi_BlockReadLock = 3;
    protected static final int CCODE_Hitachi_GetSystemInformation = 4;
    protected static final int CCODE_Hitachi_SetAttenuate = 5;
    protected static final int CCODE_Fujitsu_Refresh = 6;
    protected static final int CCODE_Fujitsu_ChgWordLock = 7;
    protected static final int CCODE_Fujitsu_ChgBlockLock = 8;
    protected static final int CCODE_Fujitsu_ReadBlockLock = 9;
    protected static final int CCODE_Fujitsu_ChgBlockGroupPassword = 10;
    protected static final int CCODE_Fujitsu_BurstWrite = 11;
    protected static final int CCODE_Fujitsu_BurstErase = 12;
    protected static final int CCODE_NXP_ReadProtect = 13;
    protected static final int CCODE_NXP_ResetReadProtect = 14;
    protected static final int CCODE_NXP_ChangeEAS = 15;
    protected static final int CCODE_NXP_EAS_Alarm = 16;
    protected static final int CCODE_NXP_Calibrate = 17;
    protected static final int CCODE_NXP_ChangeConfig = 18;
    protected static final int CCODE_EM4325_GetUID = 19;
    protected static final int CCODE_EM4325_GetSensorData = 20;
    protected static final int CCODE_EM4325_SendSPI = 21;
    protected static final int CCODE_EM4325_ResetAlarms = 22;
    protected static final int CCODE_ISO180006C_BroadcastSync = 23;
    protected static final int CCODE_IDS_SL900A_Initialize = 24;
    protected static final int CCODE_IDS_SL900A_SetLog = 25;
    protected static final int CCODE_IDS_SL900A_StartLog = 26;
    protected static final int CCODE_IDS_SL900A_EndLog = 27;
    protected static final int CCODE_IDS_SL900A_GetSensorValue = 28;
    protected static final int CCODE_IDS_SL900A_GetLogState = 29;
    protected static final int CCODE_OridaoBegin = 30;
    protected static final int CCODE_OridaoCommand = 31;
    protected static final int CCODE_OridaoEnd = 32;
    protected static final int CCODE_IDS_SL900A_SetLogLimits = 33;
    protected static final int CCODE_IDS_SL900A_GetMeasurementSetup = 34;
    protected static final int CCODE_IDS_SL900A_GetCalibrationData = 35;
    protected static final int CCODE_IDS_SL900A_OpenArea = 36;
    protected static final int CCODE_IDS_SL900A_SetPassword = 37;
    protected static final int CCODE_IDS_SL900A_GetBatteryLevel = 38;
    protected static final int CCODE_RFMicron_MAGNUSS3_ReadTemperature = 39;
    protected static final int CCODE_RFMicron_MAGNUSS3_ReadSensor = 40;
    protected static final int CCODE_RFMicron_MAGNUSS2_ReadSensor = 41;
    protected static final int CCODE_NXP_EnableBrandIdentifier = 42;
    protected static final int CCODE_AVERY_SET_COMPOUND_DATA_GENERIC_CUSTOM_REGISTER_1 = 43;
    protected static final int CCODE_AVERY_SET_COMPOUND_DATA_GENERIC_CUSTOM_REGISTER_2 = 44;
    protected static final int CCODE_AVERY_RUN = 45;
    public static final String Version = "5.0.0";
    private Socket TCPSocket;
    private CAENRFIDPort ConnectionType;
    private OutputStream RS232Out;
    private OutputStream TCPOut;
    private OutputStream BTOut;
    private InputStream RS232In;
    private InputStream TCPIn;
    private InputStream BTIn;
    private SerialPort serialPort;
    private IOBuffer _buffer;
    private boolean IsConnected;
    private CAENRFIDLogicalSource[] Sources;
    private static String[] SourceNames = new String[]{"Source_0", "Source_1", "Source_2", "Source_3"};
    private String[] Antenne = new String[]{"Ant0", "Ant1", "Ant2", "Ant3"};
    private Thread ThreadInventoryListener;
    private final Object InventoryMutex = new Object();
    private boolean InventoryInProgress = false;
    protected final Object LoopMutex = new Object();
    protected boolean Loop;
    private boolean Abort = false;
    private final Object AbortMutex = new Object();
    protected EventListenerList listenerList = new EventListenerList();
    private TCPPort TcpPort;

    public CAENRFIDReader() {
        this.Sources = new CAENRFIDLogicalSource[4];
        this.Sources[0] = new CAENRFIDLogicalSource(this, "Source_0");
        this.Sources[1] = new CAENRFIDLogicalSource(this, "Source_1");
        this.Sources[2] = new CAENRFIDLogicalSource(this, "Source_2");
        this.Sources[3] = new CAENRFIDLogicalSource(this, "Source_3");
    }

    public static String[] GetSourceNames() {
        return SourceNames;
    }

    public String[] GetReadPoints() {
        return this.Antenne;
    }

    public String GetFirmwareRelease() throws CAENRFIDException {
        String err;
        String rel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)124));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)124);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            rel = InPacket.getStringAVP((short)92, 200);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return rel;
        }
        throw new CAENRFIDException(err);
    }

    public String GetFirmwareRelease(short level) throws CAENRFIDException {
        String err;
        String rel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)124));
        size = (short)(size + OutPacket.AddShortAVP((short)131, level));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)124);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            rel = InPacket.getStringAVP((short)92, 200);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return rel;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDReaderInfo GetReaderInfo() throws CAENRFIDException {
        CAENRFIDReaderInfo info;
        String err;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        boolean out = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)158));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)158);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            String Sinfo = InPacket.getStringAVP((short)118, 256);
            String[] ReaderInfo = Sinfo.split(" ");
            err = InPacket.getAVPStatus();
            if (ReaderInfo.length < 2) {
                throw new CAENRFIDException("@ Communication Error");
            }
            info = new CAENRFIDReaderInfo(ReaderInfo[0], ReaderInfo[1]);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return info;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDReaderInfo GetReaderInfo(short level) throws CAENRFIDException {
        CAENRFIDReaderInfo info;
        String err;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)158));
        size = (short)(size + OutPacket.AddShortAVP((short)131, level));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)158);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            String Sinfo = InPacket.getStringAVP((short)118, 256);
            String[] ReaderInfo = Sinfo.split(" ");
            err = InPacket.getAVPStatus();
            if (ReaderInfo.length < 2) {
                throw new CAENRFIDException("@ Communication Error");
            }
            info = new CAENRFIDReaderInfo(ReaderInfo[0], ReaderInfo[1]);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return info;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDLogicalSource[] GetSources() {
        return this.Sources;
    }

    public CAENRFIDLogicalSource GetSource(String Source) throws CAENRFIDException {
        if (Source.equals("Source_0")) {
            return this.Sources[0];
        }
        if (Source.equals("Source_1")) {
            return this.Sources[1];
        }
        if (Source.equals("Source_2")) {
            return this.Sources[2];
        }
        if (Source.equals("Source_3")) {
            return this.Sources[3];
        }
        throw new CAENRFIDException("@ Invalid Source Name");
    }

    public void Connect(CAENRFIDPort ConType, String Address) throws CAENRFIDException {
        if (this.IsConnected) {
            throw new CAENRFIDException("Already Connected");
        }
        boolean Status = false;
        this.ConnectionType = ConType;
        if (ConType == CAENRFIDPort.CAENRFID_TCP) {
            try {
                this.TcpPort = new TCPPort();
                int port = 1000;
                try {
                    int n = port = Address.split(":").length < 2 ? 1000 : Integer.parseInt(Address.split(":")[1]);
                    if (port < 1 && port >= 65534) {
                        throw new CAENRFIDException("Invalid TCP Port");
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Tcp port number format is invalid");
                }
                this.TcpPort.connect(Address.split(":")[0], port);
                this.TCPOut = this.TcpPort.getOutputStream();
                this.TCPIn = this.TcpPort.getInputStream();
                this._buffer = new IOBuffer();
                Status = true;
                this.IsConnected = true;
            }
            catch (IOException error) {
                Status = false;
            }
            if (!Status) {
                try {
                    this.TcpPort.close();
                }
                catch (CAENRFIDException error) {
                }
                catch (NullPointerException error) {
                    // empty catch block
                }
            }
            try {
                this.TcpPort.addEventListener(this._buffer);
            }
            catch (TooManyListenersException err) {
                throw new CAENRFIDException("@ TCP Communication Error");
            }
        }
        if (ConType == CAENRFIDPort.CAENRFID_RS232) {
            String AComPort;
            int AComBaud = 115200;
            int AComDataB = 8;
            int AComStopB = 1;
            int AComParity = 0;
            boolean ok = false;
            SerialPort[] portList = SerialPort.getCommPorts();
            String[] CommArgs = Address.split(":");
            switch (CommArgs.length) {
                case 1: {
                    AComPort = CommArgs[0];
                    break;
                }
                case 2: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    break;
                }
                case 3: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (!CommArgs[2].toUpperCase().equals("S")) break;
                    AComParity = 4;
                    break;
                }
                case 4: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (CommArgs[2].toUpperCase().equals("S")) {
                        AComParity = 4;
                    }
                    AComDataB = Integer.parseInt(CommArgs[3]);
                    break;
                }
                case 5: {
                    AComPort = CommArgs[0];
                    AComBaud = Integer.parseInt(CommArgs[1]);
                    if (CommArgs[2].toUpperCase().equals("N")) {
                        AComParity = 0;
                    }
                    if (CommArgs[2].toUpperCase().equals("E")) {
                        AComParity = 2;
                    }
                    if (CommArgs[2].toUpperCase().equals("M")) {
                        AComParity = 3;
                    }
                    if (CommArgs[2].toUpperCase().equals("O")) {
                        AComParity = 1;
                    }
                    if (CommArgs[2].toUpperCase().equals("S")) {
                        AComParity = 4;
                    }
                    AComDataB = Integer.parseInt(CommArgs[3]);
                    AComStopB = Integer.parseInt(CommArgs[4]);
                    break;
                }
                default: {
                    AComPort = CommArgs[0];
                }
            }
            List<SerialPort> portArray = Arrays.asList(portList);
            Enumeration<SerialPort> portEnum = Collections.enumeration(portArray);
            while (portEnum.hasMoreElements() && !ok) {
                SerialPort portId = portEnum.nextElement();
                if (!portId.getSystemPortName().equals(AComPort.toUpperCase()) && !portId.getSystemPortName().equals(AComPort.toLowerCase()) && !portId.getSystemPortName().equals(AComPort)) continue;
                this.serialPort = portId;
                if (!this.serialPort.openPort()) {
                    throw new CAENRFIDException("@ RS232 Port in use");
                }
                ok = true;
            }
            if (!ok) {
                throw new CAENRFIDException("@ RS232 Port Not Found");
            }
            this.serialPort.setFlowControl(0);
            this.serialPort.setComPortParameters(AComBaud, AComDataB, AComStopB, AComParity, false);
            this.serialPort.setComPortTimeouts(1, 1000, 1000);
            this.RS232Out = this.serialPort.getOutputStream();
            this.RS232In = this.serialPort.getInputStream();
            Status = true;
            this._buffer = new IOBuffer();
            this.serialPort.addDataListener((SerialPortDataListener)this._buffer);
            this.IsConnected = true;
        }
        if (!Status) {
            throw new CAENRFIDException("@ Reader Not Ready");
        }
    }

    public void Disconnect() throws CAENRFIDException {
        int loop = -1;
        if (this.IsConnected) {
            if (this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                this.InventoryAbort();
                loop = 10;
                while (loop > 0) {
                    try {
                        if (this.ThreadInventoryListener.isAlive()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            --loop;
                            continue;
                        }
                        loop = -1;
                    }
                    catch (NullPointerException err) {
                        loop = -1;
                    }
                }
                if (loop == 0 && this.ThreadInventoryListener != null) {
                    this.ThreadInventoryListener.interrupt();
                }
                this.TcpPort.removeEventListener(this._buffer);
                this.TcpPort.close();
                this.IsConnected = false;
            }
            if (this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                this.InventoryAbort();
                loop = 10;
                while (loop > 0) {
                    try {
                        if (this.ThreadInventoryListener.isAlive()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException err) {
                                // empty catch block
                            }
                            --loop;
                            continue;
                        }
                        loop = -1;
                    }
                    catch (NullPointerException err) {
                        loop = -1;
                    }
                }
                if (loop == 0 && this.ThreadInventoryListener != null) {
                    this.ThreadInventoryListener.interrupt();
                }
                this.serialPort.closePort();
                this.IsConnected = false;
            }
        }
    }

    protected boolean timeoutExceeded(long start_time, long timeout) {
        return System.currentTimeMillis() - start_time >= timeout;
    }

    public boolean ForceAbort(long timeout) throws CAENRFIDException {
        boolean matched = false;
        AbortContinuosListener listener = this.ConnectionType == CAENRFIDPort.CAENRFID_RS232 ? new AbortContinuosListener(this.RS232In) : new AbortContinuosListener(this.TCPIn);
        try {
            CAENRFIDPort ConType = this.ConnectionType;
            if (ConType == CAENRFIDPort.CAENRFID_RS232) {
                this.serialPort.removeDataListener();
                this.serialPort.addDataListener((SerialPortDataListener)listener);
                this.serialPort.getOutputStream().write(171);
                this.serialPort.getOutputStream().flush();
            } else if (ConType == CAENRFIDPort.CAENRFID_TCP) {
                this.TcpPort.removeEventListener(this._buffer);
                this.TcpPort.addEventListener(listener);
                this.TcpPort.getOutputStream().write(171);
            }
            long start = System.currentTimeMillis();
            while (!this.timeoutExceeded(start, timeout)) {
                if (listener.isMatched()) {
                    matched = true;
                    break;
                }
                Thread.yield();
                if (!listener.isDataIncoming()) continue;
                start = System.currentTimeMillis();
            }
            this._buffer = new IOBuffer();
            if (ConType == CAENRFIDPort.CAENRFID_RS232) {
                this.serialPort.removeDataListener();
                this.serialPort.addDataListener((SerialPortDataListener)this._buffer);
            } else if (ConType == CAENRFIDPort.CAENRFID_TCP) {
                this.TcpPort.removeEventListener(listener);
                this.TcpPort.addEventListener(this._buffer);
            }
        }
        catch (TooManyListenersException tmle) {
            throw new CAENRFIDException("Cannot listen for abort");
        }
        catch (IOException ex) {
            throw new CAENRFIDException("Cannot send abort");
        }
        return matched;
    }

    public int GetPower() throws CAENRFIDException {
        String err;
        int power;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)115));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)115);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            power = InPacket.getIntAVP((short)82);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return power;
        }
        throw new CAENRFIDException(err);
    }

    public int GetBatteryLevel() throws CAENRFIDException {
        String err;
        int batteryLevel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)182));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)182);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            batteryLevel = InPacket.getIntAVP((short)128);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return batteryLevel;
        }
        throw new CAENRFIDException(err);
    }

    public int GetIO() throws CAENRFIDException {
        String err;
        int IO;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)134));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)134);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            IO = InPacket.getIntAVP((short)105);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return IO;
        }
        throw new CAENRFIDException(err);
    }

    public void SetIO(int IOValue) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)135));
        size = (short)(size + OutPacket.AddIntAVP((short)105, IOValue));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)135);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDBitRate GetBitRate() throws CAENRFIDException {
        String err;
        short modulation;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)129));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)129);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            modulation = InPacket.getShortAVP((short)81);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (modulation) {
                case 1: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40;
                }
                case 2: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX40RX40;
                }
                case 3: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX40RX160;
                }
                case 4: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX160RX400;
                }
                case 5: {
                    return CAENRFIDBitRate.DSB_ASK_M2_TX40RX160;
                }
                case 6: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX250;
                }
                case 7: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX300;
                }
                case 8: {
                    return CAENRFIDBitRate.PR_ASK_M2_TX40RX250;
                }
                case 10: {
                    return CAENRFIDBitRate.DSB_ASK_M4_TX40RX256;
                }
                case 11: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX320;
                }
                case 12: {
                    return CAENRFIDBitRate.PR_ASK_FM0_TX40RX640;
                }
                case 13: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX80RX320;
                }
                case 14: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX40RX256;
                }
                case 15: {
                    return CAENRFIDBitRate.DSB_ASK_M8_TX40RX256;
                }
                case 16: {
                    return CAENRFIDBitRate.PR_ASK_M2_TX133RX640;
                }
                case 17: {
                    return CAENRFIDBitRate.PR_ASK_M2_TX50RX320;
                }
                case 18: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX50RX320;
                }
                case 19: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX50RX250;
                }
                case 20: {
                    return CAENRFIDBitRate.PR_ASK_FM0_TX133RX640;
                }
                case 21: {
                    return CAENRFIDBitRate.PR_ASK_M2_TX66RX320;
                }
                case 22: {
                    return CAENRFIDBitRate.PR_ASK_M8_TX50RX160;
                }
                case 23: {
                    return CAENRFIDBitRate.PR_ASK_M4_TX133RX640;
                }
                case 24: {
                    return CAENRFIDBitRate.DSB_ASK_FM0_TX160RX640;
                }
                case 25: {
                    return CAENRFIDBitRate.DSB_ASK_M2_TX160RX640;
                }
                case 26: {
                    return CAENRFIDBitRate.PR_ASK_FM0_TX66RX426;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40;
    }

    @Deprecated
    public void FWUpgradeTFTP(String server, String filename) throws CAENRFIDException {
        short size = 10;
        String arg = "";
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        arg = server + ":" + filename;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)147));
        size = (short)(size + OutPacket.AddShortAVP((short)111, (short)1));
        size = (short)(size + OutPacket.AddStringAVP((short)112, arg));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
    }

    public CAENRFIDProtocol GetProtocol() throws CAENRFIDException {
        String err;
        int protocol;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        boolean except = false;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)121));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)121);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            protocol = InPacket.getIntAVP((short)84);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (protocol) {
                case 0: {
                    return CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                }
                case 1: {
                    return CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                }
                case 2: {
                    return CAENRFIDProtocol.CAENRFID_KEEP_ALIVE;
                }
                case 3: {
                    return CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                }
                case 4: {
                    return CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDProtocol.CAENRFID_ISO18000_6b;
    }

    public int GetReadPointPower(String readPoint) throws CAENRFIDException {
        String err;
        int power;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)190));
        size = (short)(size + OutPacket.AddStringAVP((short)34, readPoint));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[74c]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)190);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[75d]");
        }
        try {
            power = InPacket.getIntAVP((short)82);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return power;
        }
        throw new CAENRFIDException(err);
    }

    public void SetReadPointPower(String readPoint, int power) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)189));
        size = (short)(size + OutPacket.AddStringAVP((short)34, readPoint));
        size = (short)(size + OutPacket.AddIntAVP((short)150, power));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)189);
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    public void SetPower(int power) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)100));
        size = (short)(size + OutPacket.AddIntAVP((short)150, power));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)100);
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    public void PrintScreen(String Text, int TerminalType) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)181));
        size = (short)(size + OutPacket.AddShortAVP((short)127, (short)TerminalType));
        try {
            size = (short)(size + OutPacket.AddShortAVP((short)80, (short)Text.getBytes("ASCII").length));
            size = (short)(size + OutPacket.AddDataAVP((short)77, Text.getBytes("ASCII")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new CAENRFIDException(ex.getMessage());
        }
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)181);
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetBitRate(CAENRFIDBitRate BitRate) throws CAENRFIDException {
        short size = 10;
        short Modula = 1;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX10RX40) {
            Modula = 1;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX40RX40) {
            Modula = 2;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX40RX160) {
            Modula = 3;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX160RX400) {
            Modula = 4;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M2_TX40RX160) {
            Modula = 5;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX250) {
            Modula = 6;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX300) {
            Modula = 7;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M2_TX40RX250) {
            Modula = 8;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M4_TX40RX256) {
            Modula = 10;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX320) {
            Modula = 11;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_FM0_TX40RX640) {
            Modula = 12;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX80RX320) {
            Modula = 13;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX40RX256) {
            Modula = 14;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M8_TX40RX256) {
            Modula = 15;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M2_TX133RX640) {
            Modula = 16;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M2_TX50RX320) {
            Modula = 17;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX50RX320) {
            Modula = 18;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX50RX250) {
            Modula = 19;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_FM0_TX133RX640) {
            Modula = 20;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M2_TX66RX320) {
            Modula = 21;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M8_TX50RX160) {
            Modula = 22;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_M4_TX133RX640) {
            Modula = 23;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_FM0_TX160RX640) {
            Modula = 24;
        }
        if (BitRate == CAENRFIDBitRate.DSB_ASK_M2_TX160RX640) {
            Modula = 25;
        }
        if (BitRate == CAENRFIDBitRate.PR_ASK_FM0_TX66RX426) {
            Modula = 26;
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)114));
        size = (short)(size + OutPacket.AddShortAVP((short)81, Modula));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)114);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetProtocol(CAENRFIDProtocol Protocol) throws CAENRFIDException {
        int proto = 0;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        if (Protocol == CAENRFIDProtocol.CAENRFID_ISO18000_6b) {
            proto = 0;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC119) {
            proto = 0;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC_C1G1) {
            proto = 1;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_KEEP_ALIVE) {
            proto = 2;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_EPC_C1G2) {
            proto = 3;
        }
        if (Protocol == CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL) {
            proto = 4;
        }
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)116));
        size = (short)(size + OutPacket.AddIntAVP((short)84, proto));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)116);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDReadPointStatus GetReadPointStatus(String ReadPoint) throws CAENRFIDException {
        String err;
        int status;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)118));
        size = (short)(size + OutPacket.AddStringAVP((short)34, ReadPoint));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)118);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            status = InPacket.getIntAVP((short)86);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            switch (status) {
                case 0: {
                    return CAENRFIDReadPointStatus.STATUS_GOOD;
                }
                case 1: {
                    return CAENRFIDReadPointStatus.STATUS_POOR;
                }
                case 2: {
                    return CAENRFIDReadPointStatus.STATUS_BAD;
                }
            }
        } else {
            throw new CAENRFIDException(err);
        }
        return CAENRFIDReadPointStatus.STATUS_GOOD;
    }

    public float MatchReadPointImpedance(String ReadPoint) throws CAENRFIDException {
        String err;
        float status;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)180));
        size = (short)(size + OutPacket.AddStringAVP((short)34, ReadPoint));
        size = (short)(size + OutPacket.AddIntAVP((short)106, CAENRFIDMatchingParams.RPCMATCHRFALG.getIntValue()));
        size = (short)(size + OutPacket.AddIntAVP((short)107, 0));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)180);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            status = InPacket.getFloatAVP((short)83);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return status;
        }
        throw new CAENRFIDException(err);
    }

    public float MatchReadPointImpedance(String ReadPoint, CAENRFIDMatchingParams MatchParam, short MatchParamValue) throws CAENRFIDException {
        String err;
        float status;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)180));
        size = (short)(size + OutPacket.AddStringAVP((short)34, ReadPoint));
        size = (short)(size + OutPacket.AddIntAVP((short)106, MatchParam.getIntValue()));
        size = (short)(size + OutPacket.AddIntAVP((short)107, MatchParamValue));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)180);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            status = InPacket.getFloatAVP((short)83);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return status;
        }
        throw new CAENRFIDException(err);
    }

    public void SetNetwork(String IPAddress, String NetMask, String Gateway) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)122));
        size = (short)(size + OutPacket.AddStringAVP((short)88, IPAddress));
        size = (short)(size + OutPacket.AddStringAVP((short)89, NetMask));
        size = (short)(size + OutPacket.AddStringAVP((short)90, Gateway));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)122);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    public CAENRFIDNetworkInfo GetNetwork() throws CAENRFIDException {
        String err;
        CAENRFIDNetworkInfo networkInfo;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)193));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)193);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            String ipaddress = InPacket.getStringAVP((short)88, 256);
            String ipnetmask = InPacket.getStringAVP((short)89, 256);
            String ipgateway = InPacket.getStringAVP((short)90, 256);
            networkInfo = new CAENRFIDNetworkInfo(ipaddress, ipnetmask, ipgateway);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return networkInfo;
        }
        throw new CAENRFIDException(err);
    }

    @Deprecated
    public void SetReaderOPtions(short option) throws CAENRFIDException {
    }

    public void SetAdminPassword(int Password) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)172));
        size = (short)(size + OutPacket.AddIntAVP((short)115, Password));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)163);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void DoLogin(int Password) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)173));
        size = (short)(size + OutPacket.AddIntAVP((short)115, Password));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)173);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void DoLogout() throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)174));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)174);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetDateTime(String DateTime) throws CAENRFIDException {
        DateTimeFormatter caenrfidFormatter = DateTimeFormatter.ofPattern("YYYY-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(DateTime.replace(" ", "T"));
        LocalDateTime epochTime = dateTime.atOffset(OffsetDateTime.now().getOffset()).withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
        String utcDate = epochTime.format(caenrfidFormatter);
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)132));
        size = (short)(size + OutPacket.AddStringAVP((short)101, utcDate));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)132);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected CAENRFIDTag[] GetBufferedData(String Source) throws CAENRFIDException {
        int size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        ArrayList<CAENRFIDTag> tags = new ArrayList<CAENRFIDTag>();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        short size1 = (short)(size + OutPacket.AddCommand((short)176));
        OutPacket.SetPacketLength(size1);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)176);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        while (true) {
            FramedInfo finfo;
            if ((finfo = this._buffer.getFramedTag(this.GetSource(Source), false, false, false, false, false, false, false, InventorySubCommand.buildNoneSubCommand())).getResult()) {
                TagDetected = new CAENRFIDTag[tags.size()];
                tags.toArray(TagDetected);
                return TagDetected;
            }
            tags.add(finfo.getTag());
        }
    }

    protected CAENRFIDTag[] GetBufferedData(String Source, int address, int length) throws CAENRFIDException {
        int size = 10;
        CAENRFIDTag[] TagDetected = null;
        ArrayList<CAENRFIDTag> tags = new ArrayList<CAENRFIDTag>();
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        short size1 = (short)(size + OutPacket.AddCommand((short)176));
        size1 = (short)(size1 + OutPacket.AddIntAVP((short)130, address));
        size1 = (short)(size1 + OutPacket.AddIntAVP((short)129, length));
        OutPacket.SetPacketLength(size1);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)176);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        while (true) {
            FramedInfo finfo;
            if ((finfo = this._buffer.getFramedTag(this.GetSource(Source), false, false, false, false, false, false, false, InventorySubCommand.buildNoneSubCommand())).getResult()) {
                TagDetected = new CAENRFIDTag[tags.size()];
                tags.toArray(TagDetected);
                return TagDetected;
            }
            tags.add(finfo.getTag());
        }
    }

    protected int GetBufferSize(String Source) throws CAENRFIDException {
        int size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        short size1 = (short)(size + OutPacket.AddCommand((short)183));
        OutPacket.SetPacketLength(size1);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)183);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            int err = InPacket.getIntAVP((short)129);
            return err;
        }
        catch (CAENRFIDException var12) {
            throw new CAENRFIDException(var12.toString());
        }
    }

    protected void ClearBuffer(String Source) throws CAENRFIDException {
        int size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        short size1 = (short)(size + OutPacket.AddCommand((short)184));
        OutPacket.SetPacketLength(size1);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)184);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
    }

    protected CAENRFIDTag[] Inventory(String Source) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)18));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)18);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getTagsAVP(this.GetSource(Source));
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source) throws CAENRFIDException {
        return this.InventoryTag(Source, InventorySubCommand.buildNoneSubCommand());
    }

    protected CAENRFIDTag[] InventoryTag(String Source, InventorySubCommand inventorySubCommand) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        if (inventorySubCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
            size = (short)(size + OutPacket.AddShortAVP((short)103, (short)1));
            size = (short)(size + OutPacket.AddDataAVP((short)121, new byte[]{(byte)inventorySubCommand.getCommandType().getCommand()}));
            size = (short)(size + OutPacket.AddShortAVP((short)113, (short)inventorySubCommand.getMemoryBank().getBankNum()));
            size = (short)(size + OutPacket.AddShortAVP((short)78, inventorySubCommand.getMemoryBankStartAddress()));
            size = (short)(size + OutPacket.AddShortAVP((short)80, (short)(inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2READ ? inventorySubCommand.getWordsToRead() * 2 : inventorySubCommand.getWordToWrite().length)));
            if (inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2WRITE) {
                size = (short)(size + OutPacket.AddDataAVP((short)77, inventorySubCommand.getWordToWrite()));
            }
            if (inventorySubCommand.getAccessPassword() != 0) {
                size = (short)(size + OutPacket.AddIntAVP((short)115, inventorySubCommand.getAccessPassword()));
            }
        }
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVP(this.GetSource(Source));
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag) throws CAENRFIDException {
        return this.InventoryTag(Source, Mask, MaskLength, position, flag, InventorySubCommand.buildNoneSubCommand());
    }

    protected CAENRFIDTag[] InventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag, InventorySubCommand inventorySubCommand) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        boolean rssi = (flag & 1) == 1;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean XPC = (flag & 0x40) == 64;
        boolean PC = (flag & 0x100) == 256;
        boolean PHASE = (flag & 0x2000) == 8192;
        boolean FREQUENCY = (flag & 0x4000) == 16384;
        flag = (short)(flag & 0xF159);
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        if (inventorySubCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
            size = (short)(size + OutPacket.AddShortAVP((short)103, (short)1));
            size = (short)(size + OutPacket.AddDataAVP((short)121, new byte[]{(byte)inventorySubCommand.getCommandType().getCommand()}));
            size = (short)(size + OutPacket.AddShortAVP((short)113, (short)inventorySubCommand.getMemoryBank().getBankNum()));
            size = (short)(size + OutPacket.AddShortAVP((short)78, inventorySubCommand.getMemoryBankStartAddress()));
            size = (short)(size + OutPacket.AddShortAVP((short)80, (short)(inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2READ ? inventorySubCommand.getWordsToRead() * 2 : inventorySubCommand.getWordToWrite().length)));
            if (inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2WRITE) {
                size = (short)(size + OutPacket.AddDataAVP((short)77, inventorySubCommand.getWordToWrite()));
            }
            if (inventorySubCommand.getAccessPassword() != 0) {
                size = (short)(size + OutPacket.AddIntAVP((short)115, inventorySubCommand.getAccessPassword()));
            }
        }
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC, PC, PHASE, FREQUENCY);
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected CAENRFIDTag[] InventoryTag(String Source, short bank, byte[] Mask, short MaskLength, short Position, short flag) throws CAENRFIDException {
        return this.InventoryTag(Source, bank, Mask, MaskLength, Position, flag, InventorySubCommand.buildNoneSubCommand());
    }

    protected CAENRFIDTag[] InventoryTag(String Source, short bank, byte[] Mask, short MaskLength, short Position, short flag, InventorySubCommand inventorySubCommand) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag[] TagDetected = null;
        boolean rssi = (flag & 1) == 1;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean XPC = (flag & 0x40) == 64;
        boolean PC = (flag & 0x100) == 256;
        boolean PHASE = (flag & 0x2000) == 8192;
        boolean FREQUENCY = (flag & 0x4000) == 16384;
        flag = (short)(flag & 0xF159);
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, bank));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        if (inventorySubCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
            size = (short)(size + OutPacket.AddShortAVP((short)103, (short)1));
            size = (short)(size + OutPacket.AddDataAVP((short)121, new byte[]{(byte)inventorySubCommand.getCommandType().getCommand()}));
            size = (short)(size + OutPacket.AddShortAVP((short)113, (short)inventorySubCommand.getMemoryBank().getBankNum()));
            size = (short)(size + OutPacket.AddShortAVP((short)78, inventorySubCommand.getMemoryBankStartAddress()));
            size = (short)(size + OutPacket.AddShortAVP((short)80, (short)(inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2READ ? inventorySubCommand.getWordsToRead() * 2 : inventorySubCommand.getWordToWrite().length)));
            if (inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2WRITE) {
                size = (short)(size + OutPacket.AddDataAVP((short)77, inventorySubCommand.getWordToWrite()));
            }
            if (inventorySubCommand.getAccessPassword() != 0) {
                size = (short)(size + OutPacket.AddIntAVP((short)115, inventorySubCommand.getAccessPassword()));
            }
        }
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC, PC, PHASE, FREQUENCY);
            int n = tags.size();
            if (n > 0) {
                TagDetected = new CAENRFIDTag[n];
                for (int i = 0; i < n; ++i) {
                    TagDetected[i] = (CAENRFIDTag)tags.remove(0);
                }
            }
            return TagDetected;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected boolean EventInventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag) throws CAENRFIDException {
        return this.EventInventoryTag(Source, Mask, MaskLength, position, flag, InventorySubCommand.buildNoneSubCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean EventInventoryTag(String Source, byte[] Mask, short MaskLength, short position, short flag, InventorySubCommand inventorySubCommand) throws CAENRFIDException {
        boolean KEEPALIVE;
        Object object = this.InventoryMutex;
        synchronized (object) {
            if (this.InventoryInProgress) {
                return false;
            }
        }
        short size = 10;
        ArrayList<CAENRFIDNotify> NData = new ArrayList<CAENRFIDNotify>();
        short maskLen = MaskLength;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        boolean rssi = (flag & 1) == 1;
        boolean framed = (flag & 2) == 2;
        boolean continuous = (flag & 4) == 4;
        boolean compact = (flag & 8) == 8;
        boolean TID = (flag & 0x10) == 16;
        boolean EventTrigger = (flag & 0x20) == 32;
        boolean XPC = (flag & 0x40) == 64;
        boolean PC = (flag & 0x100) == 256;
        boolean PHASE = (flag & 0x2000) == 8192;
        boolean FREQUENCY = (flag & 0x4000) == 16384;
        boolean bl = KEEPALIVE = (flag & 0x1000) == 4096;
        if (compact && !framed) {
            return false;
        }
        if (continuous && !framed) {
            return false;
        }
        if (!(!EventTrigger || continuous && framed)) {
            return false;
        }
        this._buffer.SetInventoryPID(headerID);
        size = (short)(size + OutPacket.AddCommand((short)19));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)80, MaskLength));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, position));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        if (inventorySubCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
            size = (short)(size + OutPacket.AddShortAVP((short)103, (short)1));
            size = (short)(size + OutPacket.AddDataAVP((short)121, new byte[]{(byte)inventorySubCommand.getCommandType().getCommand()}));
            size = (short)(size + OutPacket.AddShortAVP((short)113, (short)inventorySubCommand.getMemoryBank().getBankNum()));
            size = (short)(size + OutPacket.AddShortAVP((short)78, inventorySubCommand.getMemoryBankStartAddress()));
            size = (short)(size + OutPacket.AddShortAVP((short)80, (short)(inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2READ ? inventorySubCommand.getWordsToRead() * 2 : inventorySubCommand.getWordToWrite().length)));
            if (inventorySubCommand.getCommandType() == InventorySubCommand.SubCommandType.G2WRITE) {
                size = (short)(size + OutPacket.AddDataAVP((short)77, inventorySubCommand.getWordToWrite()));
            }
            if (inventorySubCommand.getAccessPassword() != 0) {
                size = (short)(size + OutPacket.AddIntAVP((short)115, inventorySubCommand.getAccessPassword()));
            }
        }
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)19);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (!continuous && !framed) {
            try {
                ArrayList tags = InPacket.getIDsAVPNew(this.GetSource(Source), compact, rssi, TID, XPC, PC, PHASE, FREQUENCY);
                int n = tags.size();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        CAENRFIDTag TheTag = (CAENRFIDTag)tags.remove(0);
                        CAENRFIDNotify Notify = new CAENRFIDNotify(TheTag.GetId(), Source, TheTag.GetLength(), CAENRFIDProtocol.CAENRFID_EPC_C1G2, CAENRFIDTagEventType.TAG_GLIMPSED, Calendar.getInstance().getTime(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetReadPoint());
                        NData.add(Notify);
                    }
                }
                CAENRFIDEvent evt = NData.isEmpty() ? null : new CAENRFIDEvent(NData);
                this.fireCAENRFIDEvent(evt);
                NData.clear();
                return true;
            }
            catch (CAENRFIDException error) {
                throw new CAENRFIDException(error.toString());
            }
        }
        this.ThreadInventoryListener = new Thread(new InventoryListener(this, this.GetSource(Source), headerID, framed, rssi, TID, compact, XPC, PC, PHASE, FREQUENCY, inventorySubCommand));
        this.ThreadInventoryListener.setName("ThreadInventoryListener");
        this.ThreadInventoryListener.start();
        Object object2 = this.InventoryMutex;
        synchronized (object2) {
            this.InventoryInProgress = true;
        }
        return true;
    }

    public void addCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.add(CAENRFIDEventListener.class, listener);
    }

    public void removeCAENRFIDEventListener(CAENRFIDEventListener listener) {
        this.listenerList.remove(CAENRFIDEventListener.class, listener);
    }

    private void fireCAENRFIDEvent(CAENRFIDEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != CAENRFIDEventListener.class) continue;
            try {
                ((CAENRFIDEventListener)listeners[i + 1]).CAENRFIDTagNotify(evt);
                continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void InventoryAbort() throws CAENRFIDException {
        boolean InvinProg;
        boolean abortSent = false;
        Object object = this.InventoryMutex;
        synchronized (object) {
            if (this.InventoryInProgress) {
                CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
                OutPacket.addAbort();
                boolean Result = this._buffer.SendPacket(OutPacket);
                if (!Result) {
                    throw new CAENRFIDException("Cannot send abort!");
                }
            }
        }
        object = this.InventoryMutex;
        synchronized (object) {
            InvinProg = this.InventoryInProgress;
        }
        long time = System.currentTimeMillis();
        while (InvinProg) {
            object = this.InventoryMutex;
            synchronized (object) {
                InvinProg = this.InventoryInProgress;
            }
            if (!abortSent && System.currentTimeMillis() - time > 10000L) {
                byte[] abort = new byte[]{0, 0, 0, 8, 0, 2, 0, 0};
                if (this.ConnectionType.equals(CAENRFIDPort.CAENRFID_TCP)) {
                    this._buffer.onDataEvent(new TCPPortEvent(this, abort));
                }
                if (this.ConnectionType.equals(CAENRFIDPort.CAENRFID_RS232)) {
                    this._buffer.emulateAbort();
                }
                abortSent = true;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (abortSent) {
            throw new CAENRFIDException("Communication error: timeout.");
        }
    }

    protected byte[] ReadTagData(String Source, CAENRFIDTag tag, short address, short nbyte) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)110));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)110);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData(String Source, CAENRFIDTag tag, short address, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)111));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)111);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag(String Source, CAENRFIDTag tag, short address) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)112));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)112);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockWriteTagData(String Source, CAENRFIDTag tag, short address, short mask, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)130));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        if (mask == 255) {
            mask = (short)240;
        }
        size = (short)(size + OutPacket.AddShortAVP((short)103, mask));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)130);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G1(String Source, CAENRFIDTag tag, short passwd, boolean lock) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short llock = lock ? (short)1 : 0;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)126));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)94, passwd));
        size = (short)(size + OutPacket.AddShortAVP((short)87, llock));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)126);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC119(String Source, CAENRFIDTag tag, byte[] newID) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)148));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)77, newID));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)148);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G1(String Source, CAENRFIDTag tag, short passwd) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)127));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)94, passwd));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)127);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddReadPoint(String Source, String Antenna) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)95));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)95);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveReadPoint(String Source, String Antenna) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)96));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)96);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected short GetReadPointInSource(String Source, String Antenna) throws CAENRFIDException {
        String err;
        short present;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)120));
        size = (short)(size + OutPacket.AddStringAVP((short)34, Antenna));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)120);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            present = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return present;
        }
        throw new CAENRFIDException(err);
    }

    protected void SetSourceConfiguration(String Source, int ParType, int ParValue) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)138));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddIntAVP((short)106, ParType));
        size = (short)(size + OutPacket.AddIntAVP((short)107, ParValue));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)138);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected int GetSourceConfiguration(String Source, int ParType) throws CAENRFIDException {
        String err;
        int param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)139));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddIntAVP((short)106, ParType));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)139);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getIntAVP((short)107);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddNotifyTrigger(String Channel2, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)64));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)64);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveNotifyTrigger(String Channel2, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)66));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)66);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddSourceToChannel(String Channel2, String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)93));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)93);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveSourceFromChannel(String Channel2, String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)94));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)94);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void AddReadTrigger(String Source, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)63));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)63);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void RemoveReadTrigger(String Source, String Trigger) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)65));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)65);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckSourceInChannel(String Channel2, String Source) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)119));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)119);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckTriggerInChannel(String Channel2, String Trigger) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)143));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)143);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckSourceInTrigger(String Trigger, String Source) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)142));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)142);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected short CheckChannelInTrigger(String Trigger, String Channel2) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)144));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        size = (short)(size + OutPacket.AddStringAVP((short)32, Trigger));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)144);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, int SecurePassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, nbyte);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, Length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] ReadTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, int AccessPassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)150));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)150);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, Length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, CAENRFIDTag tag, short membank, short address, short nbyte, byte[] twrite, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, membank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void WriteTagData_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, short MemBank, short Address, short Length, byte[] Data, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)151));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)151);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockWriteTagData_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short address, short blockLength, short nbyte, byte[] twrite) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)191));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, blockLength));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[202a]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)191);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[203b]");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockWriteTagData_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short address, short blockLength, short nbyte, byte[] twrite, int accessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)191));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, address));
        size = (short)(size + OutPacket.AddShortAVP((short)80, blockLength));
        size = (short)(size + OutPacket.AddShortAVP((short)80, nbyte));
        size = (short)(size + OutPacket.AddDataAVP((short)77, twrite));
        size = (short)(size + OutPacket.AddIntAVP((short)115, accessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[202c]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)191);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[203d]");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockBlockPermalock_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, byte[] Mask, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)177));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, BlockPtr));
        size = (short)(size + OutPacket.AddShortAVP((short)80, BlockRange));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)177);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    protected byte[] ReadBlockPermalock_EPC_C1G2(String Source, CAENRFIDTag Tag, short MemBank, short BlockPtr, short BlockRange, int AccessPassword) throws CAENRFIDException {
        String err;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] param = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)178));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddShortAVP((short)113, MemBank));
        size = (short)(size + OutPacket.AddShortAVP((short)78, BlockPtr));
        size = (short)(size + OutPacket.AddShortAVP((short)80, BlockRange));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)178);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, BlockRange * 2);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, CAENRFIDTag tag, int payload) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)114, payload));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, CAENRFIDTag tag, int payload, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)114, payload));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)114, Payload));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void LockTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int Payload, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)152));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)114, Payload));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)152);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G2(String Source, CAENRFIDTag tag, int password) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)153));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddIntAVP((short)115, password));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)153);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void KillTag_EPC_C1G2(String Source, short BankMask, short PositionMask, short LengthMask, byte[] Mask, int AccessPassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)153));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)113, BankMask));
        size = (short)(size + OutPacket.AddShortAVP((short)78, PositionMask));
        size = (short)(size + OutPacket.AddShortAVP((short)15, LengthMask));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Mask));
        size = (short)(size + OutPacket.AddIntAVP((short)115, AccessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)153);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G2(String Source, CAENRFIDTag tag, short nsi) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)149));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, nsi));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)149);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ProgramID_EPC_C1G2(String Source, CAENRFIDTag tag, short nsi, int SecurePassword) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)149));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, nsi));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)149);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockProgramID_EPC_C1G2(String Source, CAENRFIDTag Tag, short NSI, short blockLength) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)192));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, NSI));
        size = (short)(size + OutPacket.AddShortAVP((short)80, blockLength));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[202a]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)192);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[203b]");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void BlockProgramID_EPC_C1G2(String Source, CAENRFIDTag Tag, short NSI, short blockLength, int accessPassword) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)192));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)116, NSI));
        size = (short)(size + OutPacket.AddShortAVP((short)80, blockLength));
        size = (short)(size + OutPacket.AddIntAVP((short)115, accessPassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[202a]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)192);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[203b]");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected boolean Query_EPC_C1G2(String Source) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)154));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)154);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        return err.equals("Status_OK");
    }

    protected byte[] QueryAck_EPC_C1G2(String Source) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)154));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)157);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            short length = (short)(this._buffer.GetPacketLength() - 10);
            param = InPacket.getDataAVP((short)77, length);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected void Untraceable_EPC_C1G2(String Source, CAENRFIDTag Tag, boolean u, boolean hideEPC, byte hideTID, boolean hideUser, short range, short newEPCLen, int password) throws CAENRFIDException {
        short size = 10;
        if (range > 3) {
            throw new CAENRFIDException("Invalid parameter");
        }
        if (hideTID > 3) {
            throw new CAENRFIDException("Invalid parameter");
        }
        short flag = range;
        if (hideUser) {
            flag = (short)(flag | 4);
        }
        flag = (short)(flag | (short)(hideTID << 3));
        if (hideEPC) {
            flag = (short)(flag | 0x20);
        }
        if (u) {
            flag = (short)(flag | 0x40);
        }
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)185));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        size = (short)(size + OutPacket.AddShortAVP((short)15, newEPCLen));
        size = (short)(size + OutPacket.AddIntAVP((short)115, password));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)185);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] Authenticate_EPC_C1G2(String Source, CAENRFIDTag Tag, boolean senRep, boolean incRepLen, char csi, byte[] challenge, short repLen, int password) throws CAENRFIDException {
        short size = 10;
        byte[] reply = null;
        short flag = (short)csi;
        if (senRep) {
            flag = (short)(flag | 0x200);
        }
        if (incRepLen) {
            flag = (short)(flag | 0x100);
        }
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)186));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddShortAVP((short)103, flag));
        size = (short)(size + OutPacket.AddShortAVP((short)80, (short)challenge.length));
        size = (short)(size + OutPacket.AddDataAVP((short)77, challenge));
        size = (short)(size + OutPacket.AddShortAVP((short)80, repLen));
        size = (short)(size + OutPacket.AddIntAVP((short)115, password));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)186);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        reply = InPacket.getDataAVP((short)77, repLen);
        String err = InPacket.getAVPStatus();
        if (err == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        if (err.equals("Status_OK")) {
            return reply;
        }
        throw new CAENRFIDException(err);
    }

    private byte[] CCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, short SubCmd, short Length, byte[] Data, short TRLength) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] temp = new byte[]{(byte)SubCmd};
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)168));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)121, temp));
        if (Length != 0) {
            size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
            size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        }
        size = (short)(size + OutPacket.AddShortAVP((short)80, TRLength));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)168);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, TRLength);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            if (error.toString().contains("Status_OK")) {
                param = new byte[]{};
                err = "Status_OK";
            }
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    private byte[] CCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, short SubCmd, short Length, byte[] Data, short TRLength, int SecurePassword) throws CAENRFIDException {
        String err;
        byte[] param;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        byte[] temp = new byte[]{(byte)SubCmd};
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)168));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)15, Tag.GetLength()));
        size = (short)(size + OutPacket.AddDataAVP((short)17, Tag.GetId()));
        size = (short)(size + OutPacket.AddDataAVP((short)121, temp));
        if (Length != 0) {
            size = (short)(size + OutPacket.AddShortAVP((short)80, Length));
            size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        }
        size = (short)(size + OutPacket.AddShortAVP((short)80, TRLength));
        size = (short)(size + OutPacket.AddIntAVP((short)115, SecurePassword));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)168);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getDataAVP((short)77, TRLength);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            if (error.toString().contains("Status_OK")) {
                param = new byte[]{};
                err = "Status_OK";
            }
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    protected byte[] CustomCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, byte SubCmd, short Length, byte[] Data, short TRLength) throws CAENRFIDException {
        try {
            byte[] param = this.CCMD_EPC_C1G2(Source, Tag, SubCmd, Length, Data, TRLength);
            return param;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void NXP_ReadProtect(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 13;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ReadProtect(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 13;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ResetReadProtect(String Source, CAENRFIDTag Tag, int Password) throws CAENRFIDException {
        byte[] data = new byte[4];
        short cmd = 14;
        short cmdlen = 4;
        short retpktlen = 1;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((Password & (0xFF00 ^ 3 - i)) >> 16);
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ResetReadProtect(String Source, CAENRFIDTag Tag, int Password, int SecurePassword) throws CAENRFIDException {
        byte[] data = new byte[4];
        short cmd = 14;
        short cmdlen = 4;
        short retpktlen = 1;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((Password & (0xFF00 ^ 3 - i)) >> 16);
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeEAS(String Source, CAENRFIDTag Tag, boolean EAS) throws CAENRFIDException {
        short cmd = 15;
        byte[] data = new byte[1];
        short cmdlen = 1;
        short retpktlen = 1;
        data[0] = EAS ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeEAS(String Source, CAENRFIDTag Tag, boolean EAS, int SecurePassword) throws CAENRFIDException {
        short cmd = 15;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = EAS ? (byte)1 : 0;
        data[0] = 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] NXP_EAS_Alarm(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        short cmd = 16;
        byte[] data = null;
        short cmdlen = 0;
        short retpktlen = 8;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] NXP_EAS_Alarm(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        short cmd = 16;
        byte[] data = null;
        short cmdlen = 0;
        short retpktlen = 8;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_Calibrate(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 17;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_Calibrate(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] data = null;
        short cmd = 17;
        short cmdlen = 0;
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeConfig(String Source, CAENRFIDTag Tag, short ConfigWord) throws CAENRFIDException {
        int cmd = 18;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = (byte)(ConfigWord >> 8);
        data[0] = (byte)ConfigWord;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, (short)cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_ChangeConfig(String Source, CAENRFIDTag Tag, short ConfigWord, int SecurePassword) throws CAENRFIDException {
        int cmd = 18;
        byte[] data = new byte[2];
        short cmdlen = 2;
        short retpktlen = 0;
        data[1] = (byte)(ConfigWord >> 8);
        data[0] = (byte)ConfigWord;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, (short)cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void NXP_EnableBrandIdentifier(String Source, boolean Enable) throws CAENRFIDException {
        byte cmd = 42;
        byte[] data = new byte[]{0, 0};
        short cmdlen = 2;
        short retpktlen = 0;
        if (Enable) {
            data[0] = 1;
        }
        try {
            byte[] ret = this.CustomCMD_EPC_C1G2(Source, null, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected CAENRFIDTag_NXP_UCODE8[] NXP_InventoryWithBrandIdentifier(String Source) throws CAENRFIDException {
        ArrayList<CAENRFIDTag_NXP_UCODE8> taglist = new ArrayList<CAENRFIDTag_NXP_UCODE8>();
        CAENRFIDTag_NXP_UCODE8[] nxp_ucode8_tags = null;
        try {
            CAENRFIDTag[] rawtags = this.InventoryTag(Source);
            if (rawtags != null) {
                int i;
                for (i = 0; i < rawtags.length; ++i) {
                    byte[] tag_id = Arrays.copyOfRange(rawtags[i].GetId(), 0, rawtags[i].GetLength() - CAENRFIDTag_NXP_UCODE8.BRAND_ID_LENGTH);
                    byte[] tag_brand_id = Arrays.copyOfRange(rawtags[i].GetId(), rawtags[i].GetLength() - CAENRFIDTag_NXP_UCODE8.BRAND_ID_LENGTH, CAENRFIDTag_NXP_UCODE8.BRAND_ID_LENGTH);
                    CAENRFIDTag_NXP_UCODE8 tag = new CAENRFIDTag_NXP_UCODE8(tag_id, (short)tag_id.length, tag_brand_id, rawtags[i].GetSource(), rawtags[i].GetReadPoint());
                    taglist.add(tag);
                }
                int tag_num = taglist.size();
                if (tag_num > 0) {
                    nxp_ucode8_tags = new CAENRFIDTag_NXP_UCODE8[tag_num];
                    for (i = 0; i < tag_num; ++i) {
                        nxp_ucode8_tags[i] = (CAENRFIDTag_NXP_UCODE8)taglist.get(0);
                        taglist.remove(0);
                    }
                }
            }
            return nxp_ucode8_tags;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_ReadLock(String Source, CAENRFIDTag Tag, short Payload) throws CAENRFIDException {
        byte[] data = new byte[2];
        short cmd = 0;
        short cmdlen = 2;
        data[0] = (byte)((Payload & 0xFF00) >> 8);
        data[1] = (byte)(Payload & 0xFF);
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_ReadLock(String Source, CAENRFIDTag Tag, short Payload, int SecurePassword) throws CAENRFIDException {
        byte[] data = new byte[2];
        short cmd = 0;
        short cmdlen = 2;
        data[0] = (byte)((Payload & 0xFF00) >> 8);
        data[1] = (byte)(Payload & 0xFF);
        short retpktlen = 1;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_WriteMultipleWords(String Source, CAENRFIDTag Tag, short MemBank, short WordPtr, byte WordCount, byte[] MaskData) throws CAENRFIDException {
        short cmd = 1;
        short cmdlen = 4;
        byte[] data = new byte[cmdlen + WordCount];
        short retpktlen = 0;
        data[0] = (byte)MemBank;
        data[1] = (byte)((WordPtr & 0xFF00) >> 8);
        data[2] = (byte)(WordPtr & 0xFF);
        data[3] = WordCount;
        for (int i = 0; i < WordCount; ++i) {
            data[i + 4] = MaskData[i];
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_WriteMultipleWords(String Source, CAENRFIDTag Tag, short MemBank, short WordPtr, byte WordCount, byte[] MaskData, int SecurePassword) throws CAENRFIDException {
        short cmd = 1;
        short cmdlen = 4;
        byte[] data = new byte[cmdlen + WordCount];
        short retpktlen = 0;
        data[0] = (byte)MemBank;
        data[1] = (byte)((WordPtr & 0xFF00) >> 8);
        data[2] = (byte)(WordPtr & 0xFF);
        data[3] = WordCount;
        for (int i = 0; i < WordCount; ++i) {
            data[i + 4] = MaskData[i];
        }
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad) throws CAENRFIDException {
        short cmd = 2;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad, int SecurePassword) throws CAENRFIDException {
        short cmd = 2;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockReadLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad) throws CAENRFIDException {
        short cmd = 3;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 1;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_BlockReadLock(String Source, CAENRFIDTag Tag, byte BlockNum, int Password, byte PayLoad, int SecurePassword) throws CAENRFIDException {
        short cmd = 3;
        short cmdlen = 6;
        byte[] data = new byte[cmdlen];
        short retpktlen = 1;
        data[0] = BlockNum;
        data[1] = (byte)((Password & 0xFF000000) >> 24);
        data[2] = (byte)((Password & 0xFF0000) >> 16);
        data[3] = (byte)((Password & 0xFF00) >> 8);
        data[4] = (byte)(Password & 0xFF);
        data[5] = PayLoad;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] Hitachi_GetSystemInfo(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        short cmd = 4;
        byte[] data = null;
        short cmdlen = 2;
        data = new byte[cmdlen];
        short retpktlen = 16;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] Hitachi_GetSystemInfo(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        short cmd = 4;
        byte[] data = null;
        short cmdlen = 2;
        data = new byte[cmdlen];
        short retpktlen = 16;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
            return ret;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_SetAttenuate(String Source, CAENRFIDTag Tag, byte level, boolean lock) throws CAENRFIDException {
        short cmd = 5;
        short cmdlen = 2;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = level;
        data[1] = lock ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Hitachi_SetAttenuate(String Source, CAENRFIDTag Tag, byte level, boolean lock, int SecurePassword) throws CAENRFIDException {
        short cmd = 5;
        short cmdlen = 2;
        byte[] data = new byte[cmdlen];
        short retpktlen = 0;
        data[0] = level;
        data[1] = lock ? (byte)1 : 0;
        try {
            byte[] ret = this.CCMD_EPC_C1G2(Source, Tag, cmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] CustomCMD_EPC_C1G2(String Source, CAENRFIDTag Tag, byte SubCmd, short Length, byte[] Data, short TRLength, int SecurePassword) throws CAENRFIDException {
        try {
            byte[] param = this.CCMD_EPC_C1G2(Source, Tag, SubCmd, Length, Data, TRLength, SecurePassword);
            return param;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_Refresh(String Source, CAENRFIDTag Tag, byte option) throws CAENRFIDException {
        byte subcmd = 6;
        short cmdlen = 2;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = option;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_Refresh(String Source, CAENRFIDTag Tag, byte option, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 6;
        short cmdlen = 2;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = option;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgWordLock(String Source, CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword) throws CAENRFIDException {
        byte subcmd = 7;
        short cmdlen = 8;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = (byte)((WordPtr & 0xFF00) >> 8);
        data[1] = (byte)(WordPtr & 0xFF);
        data[2] = 0;
        data[3] = Payload;
        data[4] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[5] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[6] = (byte)((UserPassword & 0xFF00) >> 8);
        data[7] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgWordLock(String Source, CAENRFIDTag Tag, byte MemBank, short WordPtr, byte Payload, int UserPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 7;
        short cmdlen = 8;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = (byte)((WordPtr & 0xFF00) >> 8);
        data[1] = (byte)(WordPtr & 0xFF);
        data[2] = 0;
        data[3] = Payload;
        data[4] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[5] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[6] = (byte)((UserPassword & 0xFF00) >> 8);
        data[7] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 8;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((Payload & 0xFF000000) >> 24);
        data[3] = (byte)((Payload & 0xFF0000) >> 16);
        data[4] = (byte)((Payload & 0xFF00) >> 8);
        data[5] = (byte)(Payload & 0xFF);
        data[6] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[7] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[8] = (byte)((UserPassword & 0xFF00) >> 8);
        data[9] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int Payload, int UserPassword) throws CAENRFIDException {
        byte subcmd = 8;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((Payload & 0xFF000000) >> 24);
        data[3] = (byte)((Payload & 0xFF0000) >> 16);
        data[4] = (byte)((Payload & 0xFF00) >> 8);
        data[5] = (byte)(Payload & 0xFF);
        data[6] = (byte)((UserPassword & 0xFF000000) >> 24);
        data[7] = (byte)((UserPassword & 0xFF0000) >> 16);
        data[8] = (byte)((UserPassword & 0xFF00) >> 8);
        data[9] = (byte)(UserPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte[] Fujitsu_ReadBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr) throws CAENRFIDException {
        byte subcmd = 9;
        short cmdlen = 2;
        short retpktlen = 2;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
            return TRData;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte[] Fujitsu_ReadBlockLock(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 9;
        short cmdlen = 2;
        short retpktlen = 2;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
            return TRData;
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockGroupPassword(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int CurrentPassword) throws CAENRFIDException {
        byte subcmd = 10;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((NewPassword & 0xFF000000) >> 24);
        data[3] = (byte)((NewPassword & 0xFF0000) >> 16);
        data[4] = (byte)((NewPassword & 0xFF00) >> 8);
        data[5] = (byte)(NewPassword & 0xFF);
        data[6] = (byte)((CurrentPassword & 0xFF000000) >> 24);
        data[7] = (byte)((CurrentPassword & 0xFF0000) >> 16);
        data[8] = (byte)((CurrentPassword & 0xFF00) >> 8);
        data[9] = (byte)(CurrentPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected void Fujitsu_ChgBlockGroupPassword(String Source, CAENRFIDTag Tag, byte BlockGroupPtr, int NewPassword, int CurrentPassword, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 10;
        short cmdlen = 10;
        short retpktlen = 0;
        byte[] data = new byte[cmdlen];
        data[0] = 0;
        data[1] = BlockGroupPtr;
        data[2] = (byte)((NewPassword & 0xFF000000) >> 24);
        data[3] = (byte)((NewPassword & 0xFF0000) >> 16);
        data[4] = (byte)((NewPassword & 0xFF00) >> 8);
        data[5] = (byte)(NewPassword & 0xFF);
        data[6] = (byte)((CurrentPassword & 0xFF000000) >> 24);
        data[7] = (byte)((CurrentPassword & 0xFF0000) >> 16);
        data[8] = (byte)((CurrentPassword & 0xFF00) >> 8);
        data[9] = (byte)(CurrentPassword & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstWrite(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, byte[] data) throws CAENRFIDException {
        byte subcmd = 11;
        short cmdlen = (short)(4 + nbyte);
        short retpktlen = 1;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        System.arraycopy(data, 0, dat, 4, nbyte);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstWrite(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, byte[] data, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 11;
        short cmdlen = (short)(4 + nbyte);
        short retpktlen = 1;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        System.arraycopy(data, 0, dat, 4, nbyte);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen, SecurePassword);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstErase(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte) throws CAENRFIDException {
        byte subcmd = 12;
        short cmdlen = 4;
        short retpktlen = 2;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte Fujitsu_BurstErase(String Source, CAENRFIDTag Tag, byte MemBank, short address, byte nbyte, int SecurePassword) throws CAENRFIDException {
        byte subcmd = 12;
        short cmdlen = 4;
        short retpktlen = 2;
        byte[] dat = new byte[cmdlen];
        dat[0] = MemBank;
        dat[1] = (byte)((address & 0xFF00) >> 8);
        dat[2] = (byte)(address & 0xFF);
        dat[3] = nbyte;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, dat, retpktlen, SecurePassword);
            return TRData[0];
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
    }

    protected byte[] EM4325_GetUID(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 19;
        try {
            short cmdlen = 0;
            short retpktlen = 13;
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, RTData, retpktlen);
            int UIDlen = TRData[0];
            byte[] UID = new byte[UIDlen];
            for (int i = 0; i < UIDlen; ++i) {
                UID[i] = TRData[i + 1];
            }
            return UID;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] EM4325_GetUID(String Source, CAENRFIDTag Tag, int password) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 19;
        try {
            short cmdlen = 0;
            short retpktlen = 13;
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, RTData, retpktlen, password);
            int UIDlen = TRData[0];
            byte[] UID = new byte[UIDlen];
            for (int i = 0; i < UIDlen; ++i) {
                UID[i] = TRData[i + 1];
            }
            return UID;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected EM4325TagData EM4325_GetSensorData(String Source, CAENRFIDTag Tag, boolean UIDEnable, boolean NewSample) throws CAENRFIDException {
        byte subcmd = 20;
        byte[] UID = null;
        byte[] Sensor = null;
        byte[] UTC = null;
        try {
            int i;
            short cmdlen = 1;
            short retpktlen = 8;
            byte[] RTData = new byte[cmdlen];
            if (UIDEnable) {
                RTData[0] = 1;
                retpktlen = 21;
            }
            if (NewSample) {
                RTData[0] = (byte)(RTData[0] | 2);
            }
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, RTData, retpktlen);
            EM4325TagData tag = new EM4325TagData();
            Sensor = new byte[4];
            for (i = 0; i < 3; ++i) {
                Sensor[i] = TRData[i];
            }
            UTC = new byte[4];
            for (i = 0; i < 3; ++i) {
                UTC[i] = TRData[i + 3];
            }
            if (UIDEnable) {
                int UIDlen = TRData[8];
                UID = new byte[UIDlen];
                for (i = 0; i < UIDlen; ++i) {
                    UID[i] = TRData[i + 9];
                }
            }
            tag.SetSensordata(Sensor);
            tag.SetUTC(UTC);
            tag.SetUID((byte[])(UIDEnable ? UID : null));
            return tag;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] EM4325_SendSPI(String Source, CAENRFIDTag Tag, byte SPIConfig, byte[] SPICmd, int SlaveSPILength) throws CAENRFIDException {
        return this.do_EM4325_SendSPI(Source, Tag, SPIConfig, SPICmd, SlaveSPILength, null);
    }

    protected byte[] EM4325_SendSPI(String Source, CAENRFIDTag Tag, byte SPIConfig, byte[] SPICmd, int SlaveSPILength, int SecurePassword) throws CAENRFIDException {
        return this.do_EM4325_SendSPI(Source, Tag, SPIConfig, SPICmd, SlaveSPILength, SecurePassword);
    }

    private byte[] do_EM4325_SendSPI(String Source, CAENRFIDTag Tag, byte SPIConfig, byte[] SPICmd, int SlaveSPILength, Integer SecurePassword) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 21;
        short cmdlen = 0;
        boolean length_increased_by_1 = false;
        try {
            cmdlen = (short)(SPICmd.length + 2);
            if (cmdlen % 2 == 0) {
                cmdlen = (short)(cmdlen + 1);
                length_increased_by_1 = true;
            }
            RTData = new byte[cmdlen];
            if (length_increased_by_1) {
                RTData[cmdlen - 1] = 0;
            }
            RTData[0] = (byte)SPICmd.length;
            RTData[1] = SPIConfig;
            System.arraycopy(SPICmd, 0, RTData, 2, SPICmd.length);
            byte[] TRData = SecurePassword == null ? this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, RTData, (short)SlaveSPILength) : this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, RTData, (short)SlaveSPILength, SecurePassword);
            return TRData;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void EM4325_ResetAlarms(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] data = null;
        byte subcmd = 22;
        short cmdlen = 0;
        short retpktlen = 0;
        try {
            byte[] ret = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, data, retpktlen, SecurePassword);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void ISO180006C_BroadcastSync(byte[] UTC) throws CAENRFIDException {
        String Source = null;
        CAENRFIDTag Tag = null;
        byte subcmd = 23;
        try {
            short cmdlen = 4;
            short retpktlen = 0;
            this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, cmdlen, UTC, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_Initialize(String Source, CAENRFIDTag Tag, short DelayTime, short ApplicationData) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 24;
        short subcmdlen = 4;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        RTData[0] = (byte)(DelayTime >>> 8);
        RTData[1] = (byte)(DelayTime & 0xFF);
        RTData[2] = (byte)(ApplicationData >>> 8);
        RTData[3] = (byte)(ApplicationData & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_SetLog(String Source, CAENRFIDTag Tag, int LogMode) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 25;
        short subcmdlen = 4;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        RTData[0] = 0;
        RTData[1] = (byte)(LogMode >>> 16 & 0xFF);
        RTData[2] = (byte)(LogMode >>> 8 & 0xFF);
        RTData[3] = (byte)(LogMode & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_StartLog(String Source, CAENRFIDTag Tag, int StartTime) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 26;
        short subcmdlen = 4;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        RTData[0] = (byte)(StartTime >>> 24 & 0xFF);
        RTData[1] = (byte)(StartTime >>> 16 & 0xFF);
        RTData[2] = (byte)(StartTime >>> 8 & 0xFF);
        RTData[3] = (byte)(StartTime & 0xFF);
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_EndLog(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 26;
        short subcmdlen = 0;
        short retpktlen = 0;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] IDS_SL900A_GetLogState(String Source, CAENRFIDTag Tag, boolean ShelfLife) throws CAENRFIDException {
        byte[] TRData;
        short retpktlen;
        byte[] RTData = null;
        byte subcmd = 29;
        short subcmdlen = 2;
        RTData = new byte[subcmdlen];
        if (ShelfLife) {
            RTData[0] = 0;
            RTData[1] = 1;
            retpktlen = 20;
            TRData = new byte[20];
        } else {
            RTData[0] = 0;
            RTData[1] = 0;
            retpktlen = 9;
            TRData = new byte[9];
        }
        try {
            System.arraycopy(this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen), 0, TRData, 0, TRData.length);
            return TRData;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] IDS_SL900A_GetSensorValue(String Source, CAENRFIDTag Tag, byte SensorType) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 28;
        short subcmdlen = 2;
        short retpktlen = 2;
        IDSTagData IDSData = new IDSTagData();
        RTData = new byte[subcmdlen];
        RTData[0] = 0;
        RTData[1] = SensorType;
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
            return TRData;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_SetLogLimits(String Source, CAENRFIDTag Tag, byte[] LogLimits) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 33;
        short subcmdlen = 5;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        System.arraycopy(LogLimits, 0, RTData, 0, subcmdlen);
        if (LogLimits.length != 5) {
            throw new CAENRFIDException("Invalid LogLimits Length");
        }
        try {
            byte[] TRData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] IDS_SL900A_GetMeasurementSetup(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte subcmd = 34;
        short subcmdlen = 0;
        short retpktlen = 16;
        try {
            return this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, null, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] IDS_SL900A_GetCalibrationData(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 35;
        short subcmdlen = 0;
        short retpktlen = 9;
        try {
            return this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_OpenArea(String Source, CAENRFIDTag Tag, byte PasswordLevel, int Password) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 36;
        short subcmdlen = 6;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        RTData[0] = 0;
        RTData[1] = PasswordLevel;
        RTData[2] = (byte)(Password >> 24);
        RTData[3] = (byte)(Password >> 16 & 0xFF);
        RTData[4] = (byte)(Password >> 8 & 0xFF);
        RTData[5] = (byte)(Password & 0xFF);
        try {
            byte[] byArray = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void IDS_SL900A_SetPassword(String Source, CAENRFIDTag Tag, byte PasswordLevel, int Password) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 37;
        short subcmdlen = 6;
        short retpktlen = 0;
        RTData = new byte[subcmdlen];
        RTData[0] = 0;
        RTData[1] = PasswordLevel;
        RTData[2] = (byte)(Password >> 24);
        RTData[3] = (byte)(Password >> 16 & 0xFF);
        RTData[4] = (byte)(Password >> 8 & 0xFF);
        RTData[5] = (byte)(Password & 0xFF);
        try {
            byte[] byArray = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] IDS_SL900A_GetBatteryLevel(String Source, CAENRFIDTag Tag, boolean BatteryTypeReCheck) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 38;
        short subcmdlen = 2;
        short retpktlen = 2;
        RTData = new byte[subcmdlen];
        if (BatteryTypeReCheck) {
            RTData[0] = 0;
            RTData[1] = 1;
        } else {
            RTData[0] = 0;
            RTData[1] = 0;
        }
        try {
            return this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] RFMicron_MAGNUSS3_ReadTemperature(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        return this.do_RFMicron_MAGNUS_S(Source, Tag, (byte)39, (short)0, (short)12, null);
    }

    protected byte[] RFMicron_MAGNUSS3_ReadSensor(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        return this.do_RFMicron_MAGNUS_S(Source, Tag, (byte)40, (short)0, (short)4, null);
    }

    protected byte[] RFMicron_MAGNUSS2_ReadSensor(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        return this.do_RFMicron_MAGNUS_S(Source, Tag, (byte)41, (short)0, (short)4, null);
    }

    private byte[] do_RFMicron_MAGNUS_S(String Source, CAENRFIDTag Tag, byte subcmd, short subcmdlen, short retpktlen, byte[] RTData) throws CAENRFIDException {
        try {
            return this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected short Oridao_Begin(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 30;
        short subcmdlen = 0;
        short retpktlen = 2;
        try {
            RTData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
            short handle = (short)((RTData[0] << 8) + ((short)RTData[1] & 0xFF));
            return handle;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected short Oridao_Begin(String Source, CAENRFIDTag Tag, int SecurePassword) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 30;
        short subcmdlen = 0;
        short retpktlen = 2;
        try {
            RTData = this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen, SecurePassword);
            short handle = (short)((RTData[0] << 8) + ((short)RTData[1] & 0xFF));
            return handle;
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected byte[] Oridao_Command(String Source, CAENRFIDTag Tag, short handle, short WriteLengthBit, byte[] WriteData, short ReplyLengthBit) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 31;
        short retpktlen = 0;
        short WriteLengthByte = (short)(WriteLengthBit / 8);
        if (WriteLengthBit % 8 != 0) {
            WriteLengthByte = (short)(WriteLengthByte + 1);
        }
        if (WriteLengthByte % 2 != 0) {
            WriteLengthByte = (short)(WriteLengthByte + 1);
        }
        short subcmdlen = (short)(WriteLengthByte + 6);
        RTData = new byte[subcmdlen];
        RTData[0] = (byte)(WriteLengthBit >>> 8);
        RTData[1] = (byte)(WriteLengthBit & 0xFF);
        RTData[2] = (byte)(ReplyLengthBit >>> 8);
        RTData[3] = (byte)(ReplyLengthBit & 0xFF);
        RTData[4] = (byte)(handle >>> 8);
        RTData[5] = (byte)(handle & 0xFF);
        System.arraycopy(WriteData, 0, RTData, 6, WriteLengthByte);
        retpktlen = (short)(ReplyLengthBit / 8);
        try {
            return this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void Oridao_End(String Source, CAENRFIDTag Tag) throws CAENRFIDException {
        byte[] RTData = null;
        byte subcmd = 32;
        short subcmdlen = 0;
        short retpktlen = 0;
        try {
            this.CustomCMD_EPC_C1G2(Source, Tag, subcmd, subcmdlen, RTData, retpktlen);
        }
        catch (CAENRFIDException e) {
            throw new CAENRFIDException(e.toString());
        }
    }

    protected void ChargeDeviceR1175OReader(CAENRFIDR1175OReaderConstants ChargeType, short OnOff) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)18));
        size = (short)(size + OutPacket.AddShortAVP((short)87, OnOff));
        size = (short)(size + OutPacket.AddShortAVP((short)102, ChargeType.value()));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ CommERR[101]");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)18);
        if (InPacket == null) {
            throw new CAENRFIDException("@ CommERR[102]");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public CAENRFIDRFRegulations GetRFRegulation() throws CAENRFIDException {
        String err;
        short RFRegulation;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)162));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)162);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            RFRegulation = InPacket.getShortAVP((short)119);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return new CAENRFIDRFRegulations(RFRegulation);
        }
        throw new CAENRFIDException(err);
    }

    public void SetRFRegulation(CAENRFIDRFRegulations RFRegulation) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)161));
        size = (short)(size + OutPacket.AddShortAVP((short)119, RFRegulation.getshortValue()));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)161);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public short GetRFChannel() throws CAENRFIDException {
        String err;
        short RFChannel;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)164));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)164);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            RFChannel = InPacket.getShortAVP((short)120);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return RFChannel;
        }
        throw new CAENRFIDException(err);
    }

    public void SetRFChannel(short Channel2) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)163));
        size = (short)(size + OutPacket.AddShortAVP((short)120, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)163);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    @Deprecated
    public short GetLBTMode() throws CAENRFIDException {
        String err;
        short LBTMode;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)160));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)160);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            LBTMode = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return LBTMode;
        }
        throw new CAENRFIDException(err);
    }

    @Deprecated
    public void SetLBTMode(short LBTMode) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)159));
        size = (short)(size + OutPacket.AddShortAVP((short)87, LBTMode));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)159);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public short GetFHSS() throws CAENRFIDException {
        String err;
        short LBTMode;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)160));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)160);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            LBTMode = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return LBTMode;
        }
        throw new CAENRFIDException(err);
    }

    public void SetFHSS(short enable) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)159));
        size = (short)(size + OutPacket.AddShortAVP((short)87, enable));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)159);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected void ResetSession(String Source) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)165));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)165);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    @Deprecated
    public void _SetRFOnOff(short OnOff) throws CAENRFIDException {
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)128));
        size = (short)(size + OutPacket.AddShortAVP((short)95, OnOff));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)128);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (!err.equals("Status_OK")) {
            throw new CAENRFIDException(err);
        }
    }

    protected short GetChannelStatus(String Channel2) throws CAENRFIDException {
        String err;
        short param;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)169));
        size = (short)(size + OutPacket.AddStringAVP((short)30, Channel2));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)169);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            param = InPacket.getShortAVP((short)87);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return param;
        }
        throw new CAENRFIDException(err);
    }

    public int GetIODirection() throws CAENRFIDException {
        String err;
        int IODIR;
        short size = 10;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)137));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)137);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            IODIR = InPacket.getIntAVP((short)105);
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return IODIR;
        }
        throw new CAENRFIDException(err);
    }

    public void SetIODIRECTION(int IODirection) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)136));
        size = (short)(size + OutPacket.AddIntAVP((short)105, IODirection));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)136);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    public void SetRS232(int baud, int datab, int stopb, CAENRFIDRS232Constants parity, CAENRFIDRS232Constants flowc) throws CAENRFIDException {
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)131));
        size = (short)(size + OutPacket.AddIntAVP((short)96, baud));
        size = (short)(size + OutPacket.AddIntAVP((short)97, datab));
        size = (short)(size + OutPacket.AddIntAVP((short)98, stopb));
        size = (short)(size + OutPacket.AddIntAVP((short)99, parity.getIntValue()));
        size = (short)(size + OutPacket.AddIntAVP((short)100, flowc.getIntValue()));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)131);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        String err = InPacket.getAVPStatus();
        if (err.equals("Status_OK")) {
            return;
        }
        throw new CAENRFIDException(err);
    }

    protected CAENRFIDTag GroupSelUnsel(String Source, CAENRFIDSelUnselOptions code, short Address, short BitMask, byte[] Data) throws CAENRFIDException {
        String err;
        short size = 10;
        boolean except = false;
        CAENRFIDOutPacket OutPacket = new CAENRFIDOutPacket();
        CAENRFIDTag TagDetected = null;
        short headerID = OutPacket.AddHeader();
        size = (short)(size + OutPacket.AddCommand((short)133));
        size = (short)(size + OutPacket.AddStringAVP((short)251, Source));
        size = (short)(size + OutPacket.AddShortAVP((short)102, code.getShortValue()));
        size = (short)(size + OutPacket.AddShortAVP((short)78, Address));
        size = (short)(size + OutPacket.AddShortAVP((short)103, BitMask));
        size = (short)(size + OutPacket.AddDataAVP((short)77, Data));
        OutPacket.SetPacketLength(size);
        boolean Result = this._buffer.SendPacket(OutPacket);
        if (!Result) {
            throw new CAENRFIDException("@ Communication Error");
        }
        CAENRFIDInPacket InPacket = this._buffer.GetPacket(headerID, (short)133);
        if (InPacket == null) {
            throw new CAENRFIDException("@ Communication Error");
        }
        try {
            byte[] TagID = InPacket.getDataAVP((short)17, 8);
            TagDetected = new CAENRFIDTag(TagID, CAENRFIDProtocol.CAENRFID_ISO18000_6b, 8, this.GetSource(Source), "");
            err = InPacket.getAVPStatus();
        }
        catch (CAENRFIDException error) {
            throw new CAENRFIDException(error.toString());
        }
        if (err.equals("Status_OK")) {
            return TagDetected;
        }
        throw new CAENRFIDException(err);
    }

    protected synchronized boolean getLoopStatus() {
        return this.Loop;
    }

    protected synchronized void setLoopStatus(boolean v) {
        this.Loop = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean getAbortStatus() {
        Object object = this.AbortMutex;
        synchronized (object) {
            return this.Abort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void setAbortStatus(boolean v) {
        Object object = this.AbortMutex;
        synchronized (object) {
            this.Abort = v;
        }
    }

    private class IOBuffer
    implements TCPPortEventListener,
    SerialPortDataListener {
        private ByteBuffer OBuffer;
        private ByteBuffer IBuffer;
        private ByteBuffer QBuffer;
        private byte[] global_rx_rowbuffer;
        private ByteBuffer tmp_ByteBuffer;
        private Hashtable<Short, CAENQueue> PacketCache = new Hashtable();
        private short InventoryPID = 0;
        private short ProgressID = 0;
        private final Object SerialBufferMutex = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialEvent(SerialPortEvent spe) {
            switch (spe.getEventType()) {
                case 1: {
                    int start = 0;
                    boolean HaveToEnqueue = false;
                    Object object = this.SerialBufferMutex;
                    synchronized (object) {
                        try {
                            int numBytes;
                            int size;
                            if (this.global_rx_rowbuffer == null) {
                                HaveToEnqueue = false;
                                size = 0;
                            } else {
                                HaveToEnqueue = true;
                                size = this.global_rx_rowbuffer.length;
                            }
                            int rx_data_len = CAENRFIDReader.this.RS232In.available();
                            if (rx_data_len < 1) {
                                return;
                            }
                            byte[] tmp = new byte[size += rx_data_len];
                            if (HaveToEnqueue) {
                                System.arraycopy(this.global_rx_rowbuffer, 0, tmp, 0, this.global_rx_rowbuffer.length);
                                start = this.global_rx_rowbuffer.length;
                            }
                            if ((numBytes = CAENRFIDReader.this.RS232In.read(tmp, start, rx_data_len)) != rx_data_len) {
                                // empty if block
                            }
                            this.global_rx_rowbuffer = new byte[tmp.length];
                            System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                            this.UpdateCache();
                        }
                        catch (Exception e) {
                            System.out.println(e.toString());
                        }
                    }
                    return;
                }
            }
        }

        public int getListeningEvents() {
            return 1;
        }

        private synchronized short getProgressID() {
            short p = this.ProgressID;
            this.ProgressID = (short)(this.ProgressID + 1);
            return p;
        }

        private int NBRead(int size, int TOut) {
            int Result = 0;
            boolean loop = true;
            int a = 0;
            try {
                int start = this.IBuffer.position();
                byte[] tmp = this.IBuffer.array();
                if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                    CAENRFIDReader.this.TCPSocket.setSoTimeout(TOut);
                }
                int tmp_size = size;
                while (loop) {
                    a = CAENRFIDReader.this.TCPIn.read(tmp, start, tmp_size);
                    if (a == -1) {
                        return 0;
                    }
                    start += a;
                    if ((tmp_size -= a) == 0) {
                        this.IBuffer = ByteBuffer.wrap(tmp);
                        loop = false;
                        return 1;
                    }
                    if (a != 0) continue;
                    return -1;
                }
            }
            catch (IOException error) {
                return -1;
            }
            return Result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataEvent(TCPPortEvent evt) {
            int start = 0;
            boolean HaveToEnqueue = false;
            byte[] indata = evt.getData();
            Object object = this.SerialBufferMutex;
            synchronized (object) {
                try {
                    int size;
                    if (this.global_rx_rowbuffer == null) {
                        HaveToEnqueue = false;
                        size = 0;
                    } else {
                        HaveToEnqueue = true;
                        size = this.global_rx_rowbuffer.length;
                    }
                    int rx_data_len = indata.length;
                    if (rx_data_len < 1) {
                        return;
                    }
                    byte[] tmp = new byte[size += rx_data_len];
                    if (HaveToEnqueue) {
                        System.arraycopy(this.global_rx_rowbuffer, 0, tmp, 0, this.global_rx_rowbuffer.length);
                        start = this.global_rx_rowbuffer.length;
                    }
                    System.arraycopy(indata, 0, tmp, start, rx_data_len);
                    this.global_rx_rowbuffer = new byte[tmp.length];
                    System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                    this.UpdateCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
        }

        private void UpdateCache() {
            byte[] tmp;
            int length = 0;
            short pid = 0;
            while (length + 6 < this.global_rx_rowbuffer.length) {
                int packetlen;
                if (this.global_rx_rowbuffer[length + 0] == 0 && this.global_rx_rowbuffer[length + 1] == 1 && this.global_rx_rowbuffer[length + 4] == 0 && this.global_rx_rowbuffer[length + 5] == 0) {
                    if (length + 10 < this.global_rx_rowbuffer.length) {
                        this.tmp_ByteBuffer = ByteBuffer.wrap(this.global_rx_rowbuffer);
                        this.tmp_ByteBuffer.position(length + 10 - 2);
                        packetlen = this.tmp_ByteBuffer.getShort();
                        if (packetlen == 0) {
                            packetlen = 18;
                        }
                        if (packetlen > this.global_rx_rowbuffer.length - length) {
                            if (length != 0) {
                                tmp = new byte[this.global_rx_rowbuffer.length - length];
                                System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                                this.global_rx_rowbuffer = new byte[tmp.length];
                                System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                            }
                            return;
                        }
                        tmp = new byte[packetlen];
                        System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, packetlen);
                        this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                        this.tmp_ByteBuffer.position(2);
                        pid = this.tmp_ByteBuffer.getShort();
                        this.tmp_ByteBuffer.rewind();
                        CAENQueue coda = new CAENQueue();
                        coda.enqueue(this.tmp_ByteBuffer);
                        this.PacketCache.put(pid, coda);
                        length += packetlen;
                        continue;
                    }
                    if (length != 0) {
                        tmp = new byte[this.global_rx_rowbuffer.length - length];
                        System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                        this.global_rx_rowbuffer = new byte[tmp.length];
                        System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                    }
                    return;
                }
                this.tmp_ByteBuffer = ByteBuffer.wrap(this.global_rx_rowbuffer);
                this.tmp_ByteBuffer.position(length);
                short avpheader = this.tmp_ByteBuffer.getShort();
                packetlen = this.tmp_ByteBuffer.getShort();
                if (avpheader == 0 && packetlen != 0) {
                    CAENQueue coda;
                    if (packetlen > this.global_rx_rowbuffer.length - length) {
                        if (length != 0) {
                            tmp = new byte[this.global_rx_rowbuffer.length - length];
                            System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                            this.global_rx_rowbuffer = new byte[tmp.length];
                            System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                        }
                        return;
                    }
                    tmp = new byte[packetlen];
                    System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, packetlen);
                    this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                    short type = this.tmp_ByteBuffer.getShort();
                    type = this.tmp_ByteBuffer.getShort();
                    type = this.tmp_ByteBuffer.getShort();
                    this.tmp_ByteBuffer = ByteBuffer.wrap(tmp);
                    pid = this.InventoryPID;
                    boolean res = this.PacketCache.containsKey(pid);
                    if (!res) {
                        coda = new CAENQueue();
                        coda.enqueue(this.tmp_ByteBuffer);
                        this.PacketCache.put(pid, coda);
                    } else {
                        try {
                            coda = this.PacketCache.get(pid);
                            coda.enqueue(this.tmp_ByteBuffer);
                            this.PacketCache.remove(pid);
                            this.PacketCache.put(pid, coda);
                        }
                        catch (NullPointerException err) {
                            coda = new CAENQueue();
                            coda.enqueue(this.tmp_ByteBuffer);
                            this.PacketCache.put(pid, coda);
                        }
                    }
                    length += packetlen;
                    continue;
                }
                ++length;
            }
            if (length != 0) {
                tmp = new byte[this.global_rx_rowbuffer.length - length];
                System.arraycopy(this.global_rx_rowbuffer, length, tmp, 0, this.global_rx_rowbuffer.length - length);
                this.global_rx_rowbuffer = new byte[tmp.length];
                System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
            }
        }

        private void SetInventoryPID(short p) {
            this.InventoryPID = p;
        }

        private short getAVPPid() {
            return this.InventoryPID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearGBuffer() {
            Object object = this.SerialBufferMutex;
            synchronized (object) {
                this.global_rx_rowbuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emulateAbort() {
            int start = 0;
            byte[] resCode = new byte[]{0, 0, 0, 8, 0, 2, 0, 0};
            Object object = this.SerialBufferMutex;
            synchronized (object) {
                try {
                    int size;
                    boolean HaveToEnqueue;
                    if (this.global_rx_rowbuffer == null) {
                        HaveToEnqueue = false;
                        size = 0;
                    } else {
                        HaveToEnqueue = true;
                        size = this.global_rx_rowbuffer.length;
                    }
                    int rx_data_len = 8;
                    if (rx_data_len < 1) {
                        return;
                    }
                    byte[] tmp = new byte[size += rx_data_len];
                    if (HaveToEnqueue) {
                        System.arraycopy(this.global_rx_rowbuffer, 0, tmp, 0, this.global_rx_rowbuffer.length);
                        start = this.global_rx_rowbuffer.length;
                    }
                    int numBytes = 8;
                    System.arraycopy(resCode, 0, tmp, start, numBytes);
                    this.global_rx_rowbuffer = new byte[tmp.length];
                    System.arraycopy(tmp, 0, this.global_rx_rowbuffer, 0, tmp.length);
                    this.UpdateCache();
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
        }

        private synchronized boolean SendPacket(CAENRFIDOutPacket pack) {
            byte[] tmp = pack.OBuffer.array();
            this.OBuffer = ByteBuffer.wrap(tmp);
            if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_TCP) {
                this.OBuffer.rewind();
                boolean Result = true;
                try {
                    CAENRFIDReader.this.TCPOut.flush();
                    CAENRFIDReader.this.TCPOut.write(this.OBuffer.array());
                    CAENRFIDReader.this.TCPOut.flush();
                }
                catch (IOException error) {
                    Result = false;
                }
                return Result;
            }
            if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                boolean Result = true;
                this.OBuffer.rewind();
                byte[] b = this.OBuffer.array();
                try {
                    if (this.OBuffer.capacity() != 1) {
                        CAENRFIDReader.this.RS232Out.flush();
                    }
                    CAENRFIDReader.this.RS232Out.write(b);
                    CAENRFIDReader.this.RS232Out.flush();
                }
                catch (IOException error) {
                    Result = false;
                }
                return Result;
            }
            return false;
        }

        private CAENRFIDInPacket GetPacket(short Id, short Command) {
            int i = 0;
            int to = 1000;
            CAENRFIDInPacket pack = null;
            boolean out = false;
            while (!out && i < to) {
                try {
                    pack = CAENRFIDReader.this._buffer._GetPacket(Id, Command);
                    if (pack != null) {
                        out = true;
                        continue;
                    }
                    Thread.sleep(10L);
                    ++i;
                }
                catch (IOException ioe) {
                    if (!ioe.getMessage().equals("TIMEOUT")) continue;
                    out = true;
                }
                catch (InterruptedException interruptedException) {}
            }
            return pack;
        }

        private CAENRFIDInPacket GetPacket(short Id) throws CAENRFIDException {
            int i = 0;
            int to = 100;
            CAENRFIDInPacket pack = null;
            boolean out = false;
            while (!out && i < to) {
                try {
                    pack = CAENRFIDReader.this._buffer._GetPacket(Id, (short)-1);
                    if (pack != null) {
                        out = true;
                        continue;
                    }
                    Thread.sleep(10L);
                    ++i;
                }
                catch (IOException ioe) {
                    if (!ioe.getMessage().equals("TIMEOUT")) continue;
                    out = true;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    out = true;
                }
            }
            if (i == to) {
                throw new CAENRFIDException();
            }
            return pack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized CAENRFIDInPacket _GetPacket(short Id, short Command) throws IOException {
            CAENRFIDInPacket myBuffer;
            block17: {
                ByteBuffer buff = null;
                myBuffer = null;
                CAENQueue coda = null;
                short pid = Id;
                try {
                    boolean res;
                    Object object;
                    if (CAENRFIDReader.this.ConnectionType == CAENRFIDPort.CAENRFID_RS232) {
                        object = this.SerialBufferMutex;
                        synchronized (object) {
                            res = this.PacketCache.containsKey(pid);
                            if (res) {
                                coda = this.PacketCache.get(pid);
                                buff = coda.dequeue();
                                this.PacketCache.remove(pid);
                                if (!coda.isEmpty()) {
                                    this.PacketCache.put(pid, coda);
                                }
                                myBuffer = new CAENRFIDInPacket(buff.array());
                                if (Command != -1) {
                                    res = false;
                                    res = myBuffer.CheckHeader(pid);
                                    res = myBuffer.CheckCommand(Command);
                                    if (!res) {
                                        coda = new CAENQueue();
                                        coda.enqueue(buff);
                                        this.PacketCache.put(pid, coda);
                                    }
                                }
                            }
                        }
                    }
                    if (CAENRFIDReader.this.ConnectionType != CAENRFIDPort.CAENRFID_TCP) break block17;
                    object = this.SerialBufferMutex;
                    synchronized (object) {
                        res = this.PacketCache.containsKey(pid);
                        if (res) {
                            coda = this.PacketCache.get(pid);
                            buff = coda.dequeue();
                            this.PacketCache.remove(pid);
                            if (!coda.isEmpty()) {
                                this.PacketCache.put(pid, coda);
                            }
                            myBuffer = new CAENRFIDInPacket(buff.array());
                            if (Command != -1) {
                                res = false;
                                res = myBuffer.CheckHeader(pid);
                                res = myBuffer.CheckCommand(Command);
                                if (!res) {
                                    coda = new CAENQueue();
                                    coda.enqueue(buff);
                                    this.PacketCache.put(pid, coda);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
            return myBuffer;
        }

        private boolean CheckHeaderInside(short Id) throws IOException {
            short lId;
            short TxVer;
            int pos = this.IBuffer.position();
            if (this.IBuffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = this.IBuffer.getShort();
                lId = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new IOException("BADPACKET");
            }
            int VendorID = this.IBuffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                this.IBuffer.position(pos);
                return false;
            }
            try {
                short PacketLength = this.IBuffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new IOException("BADPACKET");
            }
        }

        private short GetPacketLength() {
            int pos = this.OBuffer.position();
            this.OBuffer.position(8);
            short len = this.OBuffer.getShort();
            this.OBuffer.position(pos);
            return len;
        }

        private FramedInfo getFramedTag(CAENRFIDLogicalSource LSource, boolean rssi, boolean tid, boolean compact, boolean xpc, boolean pc, boolean phase, boolean frequency, InventorySubCommand subCommand) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = null;
            String Antenna = "";
            Date TagDate = null;
            byte[] tmp = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            CAENRFIDInPacket InPacket = new CAENRFIDInPacket(tmp);
            boolean exception = false;
            int length = 12;
            short m_rssi = 0;
            byte[] aTID = null;
            byte[] XPC = null;
            byte[] PC = null;
            byte[] PHASE = null;
            int FREQUENCY = 0;
            short TIDlen = 0;
            short subcmd = 0;
            short subcmdResult = 0;
            short subcmdResultLength = 0;
            byte[] subcmdResultData = null;
            boolean TagIsOk = false;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            CAENRFIDTag Tag = null;
            short pid = CAENRFIDReader.this._buffer.getAVPPid();
            while (!TagIsOk) {
                if (!exception) {
                    boolean waitForPacket = true;
                    while (waitForPacket) {
                        try {
                            InPacket = CAENRFIDReader.this._buffer.GetPacket(pid);
                            waitForPacket = false;
                        }
                        catch (CAENRFIDException cAENRFIDException) {}
                    }
                    if (InPacket == null) {
                        throw new CAENRFIDException("@ Communication Error");
                    }
                }
                if (compact && status < 6) {
                    status = 7;
                }
                block19 : switch (status) {
                    case 0: {
                        try {
                            pos = InPacket.position();
                            String Source = InPacket.getStringAVP((short)251, 256);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException err0) {
                            InPacket.position(pos);
                            exception = true;
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = InPacket.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException err1) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(InPacket.getDateAVP((short)16));
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException err2) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = InPacket.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException err4) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = InPacket.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_KEEP_ALIVE;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException err3) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        try {
                            pos = InPacket.position();
                            ID = InPacket.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (tid) {
                                status = 9;
                                break;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err5) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = InPacket.getAVPStatus();
                        InPacket.position(InPacket.capacity());
                        status = 0;
                        break;
                    }
                    case 7: {
                        try {
                            proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                            Antenna = "Ant0";
                            pos = InPacket.position();
                            ID = InPacket.getDataAVPCompact((short)17);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (tid) {
                                status = 9;
                                break;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            status = 0;
                        }
                        catch (CAENRFIDException err6) {
                            InPacket.position(pos);
                            exception = true;
                            status = 6;
                        }
                        break;
                    }
                    case 8: {
                        try {
                            m_rssi = InPacket.getShortAVP((short)122);
                            if (tid) {
                                status = 9;
                                break;
                            }
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err8) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        try {
                            TIDlen = InPacket.getShortAVP((short)80);
                            status = 10;
                            if (TIDlen != 0) break;
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        try {
                            aTID = InPacket.getDataAVP((short)77, TIDlen);
                            if (xpc) {
                                status = 11;
                                break;
                            }
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException e) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 11: {
                        try {
                            XPC = InPacket.getDataAVP((short)124, 4);
                            if (pc) {
                                status = 12;
                                break;
                            }
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 12: {
                        try {
                            PC = InPacket.getDataAVP((short)125, 2);
                            if (phase) {
                                status = 17;
                                break;
                            }
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            if (subCommand.getCommandType() != InventorySubCommand.SubCommandType.NONE) {
                                status = 13;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 13: {
                        try {
                            subcmd = InPacket.getDataAVP((short)121, 1)[0];
                            status = 14;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 14: {
                        try {
                            subcmdResult = InPacket.getShortAVP((short)131);
                            if (subCommand.getCommandType() == InventorySubCommand.SubCommandType.G2READ && subcmdResult == 0) {
                                status = 15;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, null);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 15: {
                        try {
                            switch (subCommand.getCommandType()) {
                                case G2READ: {
                                    subcmdResultLength = InPacket.getShortAVP((short)80);
                                    status = 16;
                                    break block19;
                                }
                                case G2WRITE: {
                                    subcmdResultLength = 0;
                                    Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, subcmdResultData);
                                    if (compact) {
                                        status = 7;
                                        break block19;
                                    }
                                    status = 0;
                                    break block19;
                                }
                            }
                            subcmdResultLength = 0;
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, subcmdResultData);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 16: {
                        try {
                            switch (subCommand.getCommandType()) {
                                case G2READ: {
                                    subcmdResultData = InPacket.getDataAVP((short)77, subcmdResultLength);
                                    Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, subcmdResultData);
                                    if (compact) {
                                        status = 7;
                                        break block19;
                                    }
                                    status = 0;
                                    break block19;
                                }
                                case G2WRITE: {
                                    subcmdResultData = null;
                                    Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, subcmdResultData);
                                    if (compact) {
                                        status = 7;
                                        break block19;
                                    }
                                    status = 0;
                                    break block19;
                                }
                            }
                            subcmdResultData = null;
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, TagDate, subcmd, subcmdResult, subcmdResultData);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 17: {
                        try {
                            PHASE = InPacket.getDataAVP((short)126, 4);
                            if (frequency) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, PHASE, FREQUENCY, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 18: {
                        try {
                            FREQUENCY = InPacket.getIntAVP((short)132);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, XPC, PC, PHASE, FREQUENCY, TagDate);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                }
                if (status != 0) continue;
                TagIsOk = true;
            }
            boolean rescod = err != null;
            FramedInfo tmpr = new FramedInfo(Tag, rescod);
            return tmpr;
        }

        private class CAENQueue {
            private LinkedList<ByteBuffer> list = new LinkedList();

            public boolean isEmpty() {
                return this.list.size() == 0;
            }

            public void enqueue(ByteBuffer item) {
                this.list.add(item);
            }

            public ByteBuffer dequeue() {
                ByteBuffer item = this.list.get(0);
                this.list.remove(0);
                return item;
            }

            public ByteBuffer peek() {
                return this.list.get(0);
            }
        }
    }

    private class CAENRFIDOutPacket {
        private ByteBuffer OBuffer;
        private byte[] OutArray;
        private short ProgressID = 0;
        private int SizeOfAVP = 0;

        public short AddHeader() {
            short id = CAENRFIDReader.this._buffer.getProgressID();
            short TxVer = -32767;
            int VendorID = 21336;
            boolean a = true;
            this.OBuffer = ByteBuffer.allocate(18);
            this.ProgressID = (short)(this.ProgressID + 1);
            this.OBuffer.putShort(TxVer);
            this.OBuffer.putShort(id);
            this.OBuffer.putInt(VendorID);
            this.OBuffer.position(10);
            return id;
        }

        public void addAbort() {
            this.OBuffer = ByteBuffer.allocate(1);
            this.OBuffer.put((byte)-85);
        }

        public short AddCommand(short c) {
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)8);
            this.OBuffer.putShort((short)1);
            this.OBuffer.putShort(c);
            return 8;
        }

        private short AddShortAVP(short AVPType, short value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + 8];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)8);
            this.OBuffer.putShort(AVPType);
            this.OBuffer.putShort(value);
            return 8;
        }

        private short AddIntAVP(short AVPType, int value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + 10];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)10);
            this.OBuffer.putShort(AVPType);
            this.OBuffer.putInt(value);
            return 10;
        }

        private short AddStringAVP(short AVPType, String value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + value.length() + 1 + 6];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)(value.length() + 1 + 6));
            this.OBuffer.putShort(AVPType);
            byte[] StrB = value.getBytes();
            this.OBuffer.put(StrB);
            this.OBuffer.put((byte)0);
            return (short)(value.length() + 1 + 6);
        }

        private short AddDataAVP(short AVPType, byte[] value) {
            int size = this.OBuffer.capacity();
            byte[] b2a = this.OBuffer.array();
            byte[] tmp = new byte[size + value.length + 6];
            System.arraycopy(b2a, 0, tmp, 0, b2a.length);
            this.OBuffer = ByteBuffer.wrap(tmp);
            this.OBuffer.position(size);
            this.OBuffer.putShort((short)0);
            this.OBuffer.putShort((short)(value.length + 6));
            this.OBuffer.putShort(AVPType);
            this.OBuffer.put(value);
            return (short)(value.length + 6);
        }

        private void SetPacketLength(short l) {
            this.OBuffer.position(8);
            this.OBuffer.putShort(l);
        }

        private short GetProgressID() {
            if (this.OBuffer.position() < 10) {
                return -1;
            }
            int pos = this.OBuffer.position();
            this.OBuffer.position(2);
            short id = this.OBuffer.getShort();
            this.OBuffer.position(pos);
            return id;
        }
    }

    private class CAENRFIDInPacket {
        private ByteBuffer IBuffer;
        private byte[] InArray;

        public CAENRFIDInPacket(byte[] InputArray) {
            this.IBuffer = ByteBuffer.wrap(InputArray);
        }

        private void position(int p) {
            this.IBuffer.position(p);
        }

        private int position() {
            return this.IBuffer.position();
        }

        private int capacity() {
            return this.IBuffer.capacity();
        }

        private boolean CheckHeader(short Id) {
            short lId;
            short TxVer;
            int pos = this.IBuffer.position();
            if (this.IBuffer.capacity() - pos < 10) {
                return false;
            }
            try {
                TxVer = this.IBuffer.getShort();
                lId = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                return false;
            }
            int VendorID = this.IBuffer.getInt();
            if (TxVer != 1 || lId != Id || VendorID != 21336) {
                this.IBuffer.position(pos);
                return false;
            }
            try {
                short PacketLength = this.IBuffer.getShort();
                return true;
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                return false;
            }
        }

        private boolean CheckCommand(short Command) {
            short Result;
            short currentType;
            short currentSize;
            int pos = 0;
            pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                return false;
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                return false;
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            if (currentType != 1) {
                return false;
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                return false;
            }
            return Result == Command;
        }

        private short getShortAVP(short AVPType) throws CAENRFIDException {
            short Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 2) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            return Result;
        }

        private int getIntAVP(short AVPType) throws CAENRFIDException {
            int Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 4) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getInt();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private long getDateAVP(short AVPType) throws CAENRFIDException {
            long Result;
            short currentType;
            short currentSize;
            long sec = 0L;
            long millisec = 0L;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 8) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                sec = this.IBuffer.getInt();
                millisec = this.IBuffer.getInt();
                Result = sec * 1000L + millisec / 1000L;
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private long getLongAVP(short AVPType) throws CAENRFIDException {
            long Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 8) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getLong();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private String getStringAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] tmp;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                tmp = new byte[currentSize - 1];
                this.IBuffer.get(tmp, 0, currentSize - 1);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            String Result = new String(tmp);
            try {
                this.IBuffer.get(tmp, 0, 1);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            return Result;
        }

        private byte[] getDataAVP(short AVPType, int AVPSize) throws CAENRFIDException {
            byte[] Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            if (AVPType != 17 && currentSize > AVPSize) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = new byte[currentSize];
                this.IBuffer.get(Result, 0, currentSize);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        protected byte[] getDataAVPCompact(short AVPType) throws CAENRFIDException {
            short currentType;
            short currentSize;
            byte[] Result = null;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = new byte[currentSize];
                this.IBuffer.get(Result, 0, currentSize);
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }

        private ArrayList getTagsAVP(CAENRFIDLogicalSource LSource) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 256);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 5;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16));
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            pos = this.IBuffer.position();
                            byte[] ID = this.getDataAVP((short)17, length);
                            CAENRFIDTag Tag = new CAENRFIDTag(ID, (short)ID.length, LSource, Antenna);
                            Tags.add(Tag);
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 0;
                        }
                        break;
                    }
                    case 5: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private ArrayList getIDsAVP(CAENRFIDLogicalSource LSource) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 256);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16));
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_KEEP_ALIVE;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        try {
                            pos = this.IBuffer.position();
                            byte[] ID = this.getDataAVP((short)17, length);
                            CAENRFIDTag Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private ArrayList getIDsAVPNew(CAENRFIDLogicalSource LSource, boolean compact, boolean rssi, boolean TID, boolean XPC, boolean PC, boolean PHASE, boolean FREQUENCY) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            int TIDlen = 4;
            short m_rssi = 0;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            byte[] TIDa = new byte[]{0, 0};
            byte[] XPCa = new byte[]{0, 0, 0, 0};
            byte[] PCa = new byte[]{0, 0};
            int frequencyData = 0;
            byte[] phaseData = new byte[]{0, 0, 0, 0};
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            if (compact) {
                status = 7;
            }
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 256);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16));
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_KEEP_ALIVE;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        CAENRFIDTag Tag;
                        try {
                            pos = this.IBuffer.position();
                            ID = this.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (TID) {
                                status = 9;
                                break;
                            }
                            if (XPC) {
                                status = 11;
                                break;
                            }
                            if (PC) {
                                status = 12;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                        break;
                    }
                    case 7: {
                        CAENRFIDTag Tag;
                        try {
                            proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                            Antenna = "Ant0";
                            pos = this.IBuffer.position();
                            ID = this.getDataAVPCompact((short)17);
                            if (rssi) {
                                status = 8;
                                break;
                            }
                            if (TID) {
                                status = 9;
                                break;
                            }
                            if (XPC) {
                                status = 11;
                                break;
                            }
                            if (PC) {
                                status = 12;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            Tags.add(Tag);
                            status = 7;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 8: {
                        CAENRFIDTag Tag;
                        try {
                            m_rssi = this.getShortAVP((short)122);
                            if (TID) {
                                status = 9;
                                break;
                            }
                            if (XPC) {
                                status = 11;
                                break;
                            }
                            if (PC) {
                                status = 12;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        CAENRFIDTag Tag;
                        try {
                            TIDlen = this.getShortAVP((short)80);
                            if (TIDlen == 0) {
                                if (XPC) {
                                    status = 11;
                                } else if (PC) {
                                    status = 12;
                                } else if (PHASE) {
                                    status = 17;
                                } else if (FREQUENCY) {
                                    status = 18;
                                } else {
                                    Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                                    Tags.add(Tag);
                                    if (compact) {
                                        status = 7;
                                        break;
                                    }
                                    status = 0;
                                    break;
                                }
                            }
                            status = 10;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        CAENRFIDTag Tag;
                        try {
                            TIDa = this.getDataAVP((short)77, TIDlen);
                            if (XPC) {
                                status = 11;
                                break;
                            }
                            if (PC) {
                                status = 12;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa, TagDate);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 11: {
                        CAENRFIDTag Tag;
                        try {
                            XPCa = this.getDataAVP((short)124, 4);
                            if (PC) {
                                status = 12;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa, XPCa, TagDate);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 12: {
                        CAENRFIDTag Tag;
                        try {
                            PCa = this.getDataAVP((short)125, 2);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa, XPCa, PCa, TagDate);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            if (PHASE) {
                                status = 17;
                                break;
                            }
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 17: {
                        CAENRFIDTag Tag;
                        try {
                            phaseData = this.getDataAVP((short)126, 4);
                            if (FREQUENCY) {
                                status = 18;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa, XPCa, PCa, phaseData, frequencyData, TagDate);
                            Tags.add(Tag);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 18: {
                        CAENRFIDTag Tag;
                        try {
                            frequencyData = this.getIntAVP((short)132);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, TIDa, XPCa, PCa, phaseData, frequencyData, TagDate);
                            if (compact) {
                                status = 7;
                                break;
                            }
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ CommERR[36_f]");
                        }
                    }
                }
            }
            if (err.equals("Status_OK")) {
                return Tags;
            }
            throw new CAENRFIDException(err);
        }

        private String getAVPStatus() {
            String Status;
            short currentType;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                String Status2 = "@ AVP_ERROR";
                return Status2;
            }
            try {
                short err = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                String Status3 = "@ AVP_ERROR";
                return Status3;
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                String Status4 = "@ AVP_ERROR";
                return Status4;
            }
            if (currentType != 2) {
                Status = "@ Internal Error!";
            } else {
                short status;
                try {
                    status = this.IBuffer.getShort();
                }
                catch (BufferUnderflowException error) {
                    String Status5 = "@ AVP_ERROR";
                    return Status5;
                }
                switch (status) {
                    case 0: {
                        Status = "Status_OK";
                        break;
                    }
                    case 100: {
                        Status = "@ Channel Name exist";
                        break;
                    }
                    case 101: {
                        Status = "@ Channel address already in use";
                        break;
                    }
                    case 102: {
                        Status = "@ Unknown Error";
                        break;
                    }
                    case 103: {
                        Status = "@ Bad Channel";
                        break;
                    }
                    case 104: {
                        Status = "@ Invalid Source Name";
                        break;
                    }
                    case 105: {
                        Status = "@ Invalid Channel Name";
                        break;
                    }
                    case 106: {
                        Status = "@ To many Channels";
                        break;
                    }
                    case 107: {
                        Status = "@ To many Sources";
                        break;
                    }
                    case 109: {
                        Status = "@ Source not in Channel";
                        break;
                    }
                    case 110: {
                        Status = "@ Bad timer value";
                        break;
                    }
                    case 111: {
                        Status = "@ Trigger name exist";
                        break;
                    }
                    case 112: {
                        Status = "@ To manu Triggers";
                        break;
                    }
                    case 113: {
                        Status = "@ Bad Trigger";
                        break;
                    }
                    case 114: {
                        Status = "@ Bad Address";
                        break;
                    }
                    case 115: {
                        Status = "@ Invalid Protocol";
                        break;
                    }
                    case 116: {
                        Status = "@ Bad Port Address";
                        break;
                    }
                    case 117: {
                        Status = "@ Can't connect to server";
                        break;
                    }
                    case 118: {
                        Status = "@ Invalid Trigger Name";
                        break;
                    }
                    case 119: {
                        Status = "@ Invalid Time";
                        break;
                    }
                    case 120: {
                        Status = "@ Source not found";
                        break;
                    }
                    case 121: {
                        Status = "@ Trigger not found";
                        break;
                    }
                    case 122: {
                        Status = "@ Channel not found";
                        break;
                    }
                    case 123: {
                        Status = "@ Bad ReadPoint";
                        break;
                    }
                    case 124: {
                        Status = "@ Channel busy";
                        break;
                    }
                    case 125: {
                        Status = "@ Trigger busy";
                        break;
                    }
                    case 126: {
                        Status = "@ Internal Filesystem error";
                        break;
                    }
                    case 127: {
                        Status = "@ Invalid Command";
                        break;
                    }
                    case 128: {
                        Status = "@ Bad Parameter's value";
                        break;
                    }
                    case 129: {
                        Status = "@ Notify Server not ready";
                        break;
                    }
                    case 183: {
                        Status = "@ Power value out of range";
                        break;
                    }
                    case 200: {
                        Status = "@ Invalid parameter";
                        break;
                    }
                    case 201: {
                        Status = "@ Logical Source disabled";
                        break;
                    }
                    case 202: {
                        Status = "@ Tag not present";
                        break;
                    }
                    case 203: {
                        Status = "@ Error writing in Tag";
                        break;
                    }
                    case 204: {
                        Status = "@ Error in reading Tag";
                        break;
                    }
                    case 205: {
                        Status = "@ Bad Tag's address";
                        break;
                    }
                    case 206: {
                        Status = "@ Invalid function";
                        break;
                    }
                    case 207: {
                        Status = "@ Select/Unselect error";
                        break;
                    }
                    case 209: {
                        Status = "@ Tag Locked";
                        break;
                    }
                    case 210: {
                        Status = "@ Unsupported";
                        break;
                    }
                    case 211: {
                        Status = "@ Power Error";
                        break;
                    }
                    case 212: {
                        Status = "@ Non Specific Error";
                        break;
                    }
                    case 213: {
                        Status = "@ Kill Tag Error";
                        break;
                    }
                    case 214: {
                        Status = "@ Channels Fulls";
                        break;
                    }
                    default: {
                        Status = "@ Generic Error";
                    }
                }
            }
            return Status;
        }

        protected NotFramedInfo getNotFramedTags(CAENRFIDLogicalSource LSource, boolean rssi, boolean tid) throws CAENRFIDException {
            int pos = 0;
            int status = 0;
            String err = "@ Communication Error";
            String Antenna = "";
            Date TagDate = null;
            int length = 12;
            short m_rssi = 0;
            short TIDlen = 0;
            CAENRFIDProtocol proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
            byte[] ID = new byte[]{0, 0};
            ArrayList<CAENRFIDTag> Tags = new ArrayList<CAENRFIDTag>();
            while (this.IBuffer.position() < this.IBuffer.capacity()) {
                switch (status) {
                    case 0: {
                        try {
                            pos = this.IBuffer.position();
                            String Source = this.getStringAVP((short)251, 256);
                            if (!Source.equals(LSource.GetName())) {
                                throw new CAENRFIDException("@ Communication Error");
                            }
                            status = 1;
                        }
                        catch (CAENRFIDException error) {
                            this.IBuffer.position(pos);
                            status = 6;
                        }
                        break;
                    }
                    case 1: {
                        try {
                            Antenna = this.getStringAVP((short)34, 5);
                            status = 2;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 2: {
                        try {
                            TagDate = new Date(this.getDateAVP((short)16));
                            status = 3;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 4: {
                        try {
                            length = this.getShortAVP((short)15);
                            status = 5;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 3: {
                        try {
                            short TagType = this.getShortAVP((short)18);
                            switch (TagType) {
                                case 0: {
                                    proto = CAENRFIDProtocol.CAENRFID_ISO18000_6b;
                                    break;
                                }
                                case 1: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G1;
                                    break;
                                }
                                case 2: {
                                    proto = CAENRFIDProtocol.CAENRFID_KEEP_ALIVE;
                                    break;
                                }
                                case 3: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC_C1G2;
                                    break;
                                }
                                case 4: {
                                    proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
                                    break;
                                }
                                case 5: {
                                    proto = CAENRFIDProtocol.CAENRFID_EPC119;
                                }
                            }
                            status = 4;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 5: {
                        CAENRFIDTag Tag;
                        try {
                            pos = this.IBuffer.position();
                            ID = this.getDataAVP((short)17, length);
                            if (rssi) {
                                status = 7;
                                break;
                            }
                            if (tid) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 6: {
                        err = this.getAVPStatus();
                        this.IBuffer.position(this.IBuffer.capacity());
                        break;
                    }
                    case 7: {
                        CAENRFIDTag Tag;
                        try {
                            m_rssi = this.getShortAVP((short)122);
                            if (tid) {
                                status = 9;
                                break;
                            }
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 9: {
                        CAENRFIDTag Tag;
                        try {
                            TIDlen = this.getShortAVP((short)80);
                            if (TIDlen == 0) {
                                Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, null, TagDate);
                                Tags.add(Tag);
                                status = 0;
                                break;
                            }
                            status = 10;
                            break;
                        }
                        catch (CAENRFIDException error) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                    case 10: {
                        CAENRFIDTag Tag;
                        try {
                            byte[] aTID = this.getDataAVP((short)77, TIDlen);
                            Tag = new CAENRFIDTag(ID, proto, (short)ID.length, LSource, Antenna, m_rssi, aTID, TagDate);
                            Tags.add(Tag);
                            status = 0;
                            break;
                        }
                        catch (CAENRFIDException err10) {
                            throw new CAENRFIDException("@ Communication Error");
                        }
                    }
                }
            }
            boolean rescod = err.equals("Status_OK");
            return new NotFramedInfo(Tags, rescod);
        }

        private float getFloatAVP(short AVPType) throws CAENRFIDException {
            float Result;
            short currentType;
            short currentSize;
            int pos = this.IBuffer.position();
            try {
                this.IBuffer.position(pos + 2);
            }
            catch (IllegalArgumentException err) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            try {
                currentSize = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            currentSize = (short)(currentSize - 6);
            if (currentSize != 4) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                currentType = this.IBuffer.getShort();
            }
            catch (BufferUnderflowException error) {
                throw new CAENRFIDException("@ AVP_ERROR");
            }
            if (currentType != AVPType) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            try {
                Result = this.IBuffer.getFloat();
            }
            catch (BufferUnderflowException error) {
                this.IBuffer.position(pos);
                throw new CAENRFIDException(this.getAVPStatus());
            }
            return Result;
        }
    }

    protected static class AbortContinuosListener
    implements TCPPortEventListener,
    SerialPortDataListener {
        byte b;
        byte[] match_bb = new byte[]{0, 0, 0, 8, 0, 2, 0, 0};
        int match_bb_i = 0;
        byte[] bb = new byte[4096];
        boolean match = false;
        boolean matching = false;
        boolean end = false;
        boolean isDataIncoming = false;
        final Object syncObject = new Object();
        final InputStream input;

        public AbortContinuosListener() {
            this.input = null;
        }

        private AbortContinuosListener(InputStream in) {
            this.input = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMatched() {
            boolean result;
            Object object = this.syncObject;
            synchronized (object) {
                result = this.match;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDataIncoming() {
            boolean result;
            Object object = this.syncObject;
            synchronized (object) {
                result = this.isDataIncoming;
                this.isDataIncoming = false;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseMessage(byte[] data) {
            Object object = this.syncObject;
            synchronized (object) {
                this.isDataIncoming = true;
            }
            int av = data.length;
            for (int i = 0; i < av; ++i) {
                this.b = data[i];
                if (this.match_bb[this.match_bb_i] == this.b) {
                    System.out.print(Byte.toString(this.b));
                    if (this.match_bb_i == this.match_bb.length - 1) {
                        i = av;
                        Object object2 = this.syncObject;
                        synchronized (object2) {
                            this.match = true;
                            this.isDataIncoming = false;
                            break;
                        }
                    }
                    ++this.match_bb_i;
                    continue;
                }
                this.match_bb_i = 0;
            }
        }

        @Override
        public void onDataEvent(TCPPortEvent evt) {
            this.parseMessage(evt.getData());
        }

        public void serialEvent(SerialPortEvent spe) {
            if (spe.getEventType() != 1) {
                return;
            }
            try {
                int n = this.input.available();
                while (n > 0) {
                    byte[] bb = new byte[n];
                    this.input.read(bb, 0, n);
                    this.parseMessage(bb);
                    n = this.input.available();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int getListeningEvents() {
            return 1;
        }
    }

    private class FramedInfo {
        private CAENRFIDTag Tag;
        private boolean rescod;

        public FramedInfo(CAENRFIDTag tag, boolean res) {
            this.Tag = tag;
            this.rescod = res;
        }

        public CAENRFIDTag getTag() {
            return this.Tag;
        }

        public boolean getResult() {
            return this.rescod;
        }
    }

    private class InventoryListener
    implements Runnable {
        private boolean ThereIsRSSI;
        private boolean IsCompact;
        private boolean IsFramed;
        private boolean ThereIsTID;
        private boolean ThereIsXPC;
        private boolean ThereIsPC;
        private boolean ThereIsPHASE;
        private boolean ThereIsFREQUENCY;
        private InventorySubCommand aSubCommand;
        private CAENRFIDReader TheReader;
        private CAENRFIDLogicalSource TheSource;
        private short id;

        public InventoryListener(CAENRFIDReader Reader, CAENRFIDLogicalSource Source, short headerID, boolean framed, boolean rssi, boolean tid, boolean compact, boolean xpc, boolean pc, boolean phase, boolean frequency, InventorySubCommand subCommand) {
            this.TheReader = Reader;
            this.id = headerID;
            this.TheSource = Source;
            this.ThereIsRSSI = rssi;
            this.ThereIsTID = tid;
            this.ThereIsXPC = xpc;
            this.ThereIsPC = pc;
            this.ThereIsPHASE = phase;
            this.ThereIsFREQUENCY = frequency;
            this.IsCompact = compact;
            this.IsFramed = framed;
            this.aSubCommand = subCommand;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object TagDate = null;
            boolean loop = true;
            boolean ResultCode = false;
            ArrayList<CAENRFIDNotify> NData = new ArrayList<CAENRFIDNotify>();
            long t0 = 0L;
            while (loop) {
                CAENRFIDNotify Notify;
                CAENRFIDTag TheTag;
                long t1 = System.currentTimeMillis();
                if (this.IsFramed) {
                    FramedInfo Finfo;
                    try {
                        Finfo = CAENRFIDReader.this._buffer.getFramedTag(this.TheSource, this.ThereIsRSSI, this.ThereIsTID, this.IsCompact, this.ThereIsXPC, this.ThereIsPC, this.ThereIsPHASE, this.ThereIsFREQUENCY, this.aSubCommand);
                        TheTag = Finfo.getTag();
                    }
                    catch (Exception excpt) {
                        continue;
                    }
                    if (Finfo.getResult()) {
                        loop = false;
                    }
                    if (TheTag == null) continue;
                    try {
                        Notify = new CAENRFIDNotify(TheTag.GetId(), this.TheSource.GetName(), TheTag.GetLength(), TheTag.GetType(), CAENRFIDTagEventType.TAG_GLIMPSED, TheTag.GetTimeStamp(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetXPC(), TheTag.GetPC(), TheTag.GetPhaseBegin(), TheTag.GetPhaseEnd(), TheTag.GetFrequency(), TheTag.GetReadPoint());
                        NData.add(Notify);
                    }
                    catch (CAENRFIDException excpt) {}
                } else {
                    CAENRFIDInPacket InPacket = CAENRFIDReader.this._buffer.GetPacket(this.id, (short)19);
                    if (InPacket == null) continue;
                    try {
                        ArrayList tags;
                        int n;
                        NotFramedInfo NFinfo = InPacket.getNotFramedTags(this.TheSource, this.ThereIsRSSI, this.ThereIsTID);
                        if (NFinfo.getResult()) {
                            loop = false;
                        }
                        if ((n = (tags = NFinfo.getTags()).size()) > 0) {
                            for (int i = 0; i < n; ++i) {
                                TheTag = (CAENRFIDTag)tags.remove(0);
                                try {
                                    Notify = new CAENRFIDNotify(TheTag.GetId(), this.TheSource.GetName(), TheTag.GetLength(), TheTag.GetType(), CAENRFIDTagEventType.TAG_GLIMPSED, TheTag.GetTimeStamp(), TheTag.GetRSSI(), TheTag.GetTID(), TheTag.GetReadPoint());
                                    NData.add(Notify);
                                    continue;
                                }
                                catch (CAENRFIDException excpt) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (CAENRFIDException excpt) {
                        // empty catch block
                    }
                }
                CAENRFIDEvent evt = NData.isEmpty() ? null : new CAENRFIDEvent(NData);
                this.TheReader.fireCAENRFIDEvent(evt);
                NData.clear();
            }
            Object object = CAENRFIDReader.this.InventoryMutex;
            synchronized (object) {
                this.TheReader.InventoryInProgress = false;
            }
        }
    }

    public static enum CAENRFIDR1175OReaderConstants {
        CHARGETYPE_R1175O(0),
        CHARGETYPE_DEV_DEFAULT(1),
        CHARGETYPE_DEV_ANDROID_HIGH(2),
        CHARGETYPE_DEV_ANDROID_LOW(3),
        CHARGETYPE_DEV_IOS_HIGH(4),
        CHARGETYPE_DEV_IOS_LOW(5);

        private byte _value;

        private CAENRFIDR1175OReaderConstants(byte value) {
            this._value = value;
        }

        public byte value() {
            return this._value;
        }
    }

    private class NotFramedInfo {
        private ArrayList<CAENRFIDTag> TagsArray;
        private boolean rescod;

        public NotFramedInfo(ArrayList<CAENRFIDTag> tags, boolean res) {
            this.TagsArray = tags;
            this.rescod = res;
        }

        public ArrayList getTags() {
            return this.TagsArray;
        }

        public boolean getResult() {
            return this.rescod;
        }
    }
}

