/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDProtocol;
import com.caen.RFIDLibrary.CAENRFIDTagEventType;
import java.util.Date;

public class CAENRFIDNotify {
    private byte[] tagID;
    private String Source;
    private short TagLength;
    private CAENRFIDTagEventType Status;
    private CAENRFIDProtocol Type;
    private Date TimeStamp;
    private String Antenna = "Not Available";
    private short Rssi = 0;
    private byte[] TID;
    private byte[] XPC;
    private byte[] PC;
    private float phaseBegin;
    private float phaseEnd;
    private long frequency;
    private short subcmd_code = 0;
    private short subcmd_resultcode = 0;
    private byte[] subcmd_data;

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, String antenna, short subCommand, short subCommandResult, byte[] subCommandData) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
        this.subcmd_code = subCommand;
        this.subcmd_resultcode = subCommandResult;
        this.subcmd_data = subCommandData;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, byte[] phase, int frequency, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = this.getPhase(phase, true);
        this.phaseEnd = this.getPhase(phase, false);
        this.frequency = frequency;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, byte[] phase, int frequency, String antenna, short subCommand, short subCommandResult, byte[] subCommandData) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = this.getPhase(phase, true);
        this.phaseEnd = this.getPhase(phase, false);
        this.frequency = frequency;
        this.subcmd_code = subCommand;
        this.subcmd_resultcode = subCommandResult;
        this.subcmd_data = subCommandData;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, float phaseB, float phaseE, long frequency, String antenna) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = phaseB;
        this.phaseEnd = phaseE;
        this.frequency = frequency;
    }

    protected CAENRFIDNotify(byte[] id, String LS, short len, CAENRFIDProtocol type, CAENRFIDTagEventType St, Date ts, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, float phaseB, float phaseE, long frequency, String antenna, short subCommand, short subCommandResult, byte[] subCommandData) {
        this.tagID = new byte[id.length];
        System.arraycopy(id, 0, this.tagID, 0, id.length);
        this.Source = LS;
        this.TagLength = len;
        this.Status = St;
        this.Type = type;
        this.TimeStamp = ts;
        this.Antenna = antenna;
        this.Rssi = rssi;
        this.TID = tTID;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = phaseB;
        this.phaseEnd = phaseE;
        this.frequency = frequency;
        this.subcmd_code = subCommand;
        this.subcmd_resultcode = subCommandResult;
        this.subcmd_data = subCommandData;
    }

    private float getPhase(byte[] phase, boolean start) {
        short phaseLen = (short)(phase[start ? 2 : 0] << 8 | phase[start ? 3 : 1]);
        phaseLen = (short)((phaseLen & 0xFFF0) >> 4);
        return 0.087f * (float)phaseLen;
    }

    public byte[] getTagID() {
        return this.tagID;
    }

    public String getTagSource() {
        return this.Source;
    }

    public short getTagLength() {
        return this.TagLength;
    }

    public CAENRFIDProtocol getTagType() {
        return this.Type;
    }

    @Deprecated
    public CAENRFIDTagEventType getStatus() {
        return this.Status;
    }

    @Deprecated
    public String getAntenna() {
        return this.Antenna;
    }

    public String getReadPoint() {
        return this.Antenna;
    }

    public Date getDate() {
        return this.TimeStamp;
    }

    public short getRSSI() {
        return this.Rssi;
    }

    public byte[] getTID() {
        return this.TID;
    }

    public byte[] getXPC() {
        return this.XPC;
    }

    public byte[] getPC() {
        return this.PC;
    }

    public float GetPhaseBegin() {
        return this.phaseBegin;
    }

    public float GetPhaseEnd() {
        return this.phaseEnd;
    }

    public long GetFrequency() {
        return this.frequency;
    }

    public short getSubCommandCode() {
        return this.subcmd_code;
    }

    public short getSubCommandResultCode() {
        return this.subcmd_resultcode;
    }

    public byte[] getSubcommandData() {
        return this.subcmd_data;
    }
}

