/*
 * Decompiled with CFR 0.152.
 */
package com.caen.TCPPort;

import com.caen.TCPPort.TCPPort;
import com.caen.TCPPort.TCPPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TCPPortEventThread
extends Thread {
    private static final int MAX_INBUFFER_LEN = 2048;
    protected TCPPort mTCPPort;

    public TCPPortEventThread(TCPPort Port) {
        this.mTCPPort = Port;
        this.setName("TCPPortEventThread");
    }

    @Override
    public void run() {
        InputStream TCPIn;
        try {
            TCPIn = this.mTCPPort.getInputStream();
        }
        catch (IOException e1) {
            return;
        }
        try {
            byte[] data = new byte[2048];
            while (true) {
                if (this.isInterrupted()) {
                    return;
                }
                int nData = TCPIn.read(data);
                if (nData == -1 || nData == 0) {
                    return;
                }
                byte[] temp = Arrays.copyOf(data, nData);
                this.mTCPPort.fireOnDataEvent(new TCPPortEvent(this, temp));
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void run_old() {
        InputStream TCPIn;
        try {
            TCPIn = this.mTCPPort.getInputStream();
        }
        catch (IOException e1) {
            return;
        }
        try {
            int ndata = 0;
            while (true) {
                if (ndata <= 0) {
                    ndata = TCPIn.available();
                    Thread.yield();
                    continue;
                }
                if (ndata <= 0) continue;
                byte[] data = new byte[ndata];
                TCPIn.read(data, 0, ndata);
                this.mTCPPort.fireOnDataEvent(new TCPPortEvent(this, (byte[])data.clone()));
                ndata = 0;
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

