/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDTag;

public class InventorySubCommand {
    private final SubCommandType commandType;
    private final CAENRFIDTag.MemBanks memoryBank;
    private final short memoryBankStartAddress;
    private final short wordsToRead;
    private final byte[] wordToWrite;
    private final int accessPassword;

    public static InventorySubCommand buildReadSubCommand(CAENRFIDTag.MemBanks memoryBank, int startAddress, int wordCount, int accessPassword) {
        return new InventorySubCommand(SubCommandType.G2READ, memoryBank, (short)startAddress, (short)wordCount, null, accessPassword);
    }

    public static InventorySubCommand buildWriteSubCommand(CAENRFIDTag.MemBanks memoryBank, int startAddress, byte[] wordToWrite, int accessPassword) {
        return new InventorySubCommand(SubCommandType.G2WRITE, memoryBank, (short)startAddress, 0, wordToWrite, accessPassword);
    }

    public static InventorySubCommand buildNoneSubCommand() {
        return new InventorySubCommand(SubCommandType.NONE, CAENRFIDTag.MemBanks.EPC, 0, 0, null, 0);
    }

    private InventorySubCommand(SubCommandType commandType, CAENRFIDTag.MemBanks memoryBank, short memoryBankStartAddress, short wordToRead, byte[] wordToWrite, int password) {
        this.commandType = commandType;
        this.memoryBank = memoryBank;
        this.memoryBankStartAddress = memoryBankStartAddress;
        this.wordsToRead = wordToRead;
        this.wordToWrite = wordToWrite;
        this.accessPassword = password;
    }

    public SubCommandType getCommandType() {
        return this.commandType;
    }

    public CAENRFIDTag.MemBanks getMemoryBank() {
        return this.memoryBank;
    }

    public short getMemoryBankStartAddress() {
        return this.memoryBankStartAddress;
    }

    public short getWordsToRead() {
        return this.wordsToRead;
    }

    public byte[] getWordToWrite() {
        return this.wordToWrite;
    }

    public int getAccessPassword() {
        return this.accessPassword;
    }

    public static enum SubCommandType {
        NONE(0),
        G2READ(150),
        G2WRITE(151);

        private final short command;

        private SubCommandType(short cmd) {
            this.command = cmd;
        }

        public short getCommand() {
            return this.command;
        }
    }
}

