/*
 * Decompiled with CFR 0.152.
 */
package com.caen.RFIDLibrary;

import com.caen.RFIDLibrary.CAENRFIDException;
import com.caen.RFIDLibrary.CAENRFIDLogicalSource;
import com.caen.RFIDLibrary.CAENRFIDProtocol;
import java.util.Date;

public class CAENRFIDTag {
    private CAENRFIDLogicalSource LogicalSource;
    private short TagLength;
    private byte[] TagID;
    private byte[] TID;
    private byte[] XPC;
    private byte[] PC;
    private float phaseBegin;
    private float phaseEnd;
    private long frequency;
    private CAENRFIDProtocol proto;
    private String TReadPoint = "Not Available";
    private Date TimeStamp = null;
    private short m_rssi = 0;
    private short subcmd_code = 0;
    private short subcmd_resultcode = 0;
    private byte[] subcmd_data;

    public CAENRFIDTag(byte[] Id, short length, CAENRFIDLogicalSource Source) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
    }

    public CAENRFIDTag(byte[] Id, short length, CAENRFIDLogicalSource Source, String ReadPoint) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = CAENRFIDProtocol.CAENRFID_MULTYPROTOCOL;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        this.TID = null;
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.proto = type;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, Date timestamp) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.TID = null;
        this.proto = type;
        this.TimeStamp = timestamp;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        this.TID = null;
        this.proto = type;
        this.m_rssi = rssi;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, Date time) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, Date time) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, Date time) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
        this.PC = tPC;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, Date time, short subCommand, short subCommandResult, byte[] subCommandData) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
        this.PC = tPC;
        this.subcmd_code = subCommand;
        this.subcmd_resultcode = subCommandResult;
        this.subcmd_data = subCommandData;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, byte[] phase, int frequency, Date time) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = this.getPhase(phase, true);
        this.phaseEnd = this.getPhase(phase, false);
        this.frequency = frequency;
    }

    protected CAENRFIDTag(byte[] Id, CAENRFIDProtocol type, short length, CAENRFIDLogicalSource Source, String ReadPoint, short rssi, byte[] tTID, byte[] tXPC, byte[] tPC, byte[] phase, int frequency, Date time, short subCommand, short subCommandResult, byte[] subCommandData) throws CAENRFIDException {
        if (Id.length > 2048) {
            throw new CAENRFIDException("@ Invalid Tag");
        }
        this.LogicalSource = Source;
        this.TagLength = length;
        this.TReadPoint = ReadPoint;
        this.TagID = new byte[this.TagLength];
        System.arraycopy(Id, 0, this.TagID, 0, this.TagLength);
        if (tTID != null) {
            this.TID = new byte[tTID.length];
            System.arraycopy(tTID, 0, this.TID, 0, tTID.length);
        } else {
            this.TID = null;
        }
        this.proto = type;
        this.m_rssi = rssi;
        this.TimeStamp = time;
        this.XPC = tXPC;
        this.PC = tPC;
        this.phaseBegin = this.getPhase(phase, true);
        this.phaseEnd = this.getPhase(phase, false);
        this.frequency = frequency;
        this.subcmd_code = subCommand;
        this.subcmd_resultcode = subCommandResult;
        this.subcmd_data = subCommandData;
    }

    private float getPhase(byte[] phase, boolean start) {
        short phaseLen = (short)(phase[start ? 2 : 0] << 8 | phase[start ? 3 : 1]);
        phaseLen = (short)((phaseLen & 0xFFF0) >> 4);
        return 0.087f * (float)phaseLen;
    }

    public byte[] GetId() {
        return this.TagID;
    }

    public byte[] GetTID() {
        return this.TID;
    }

    public short GetLength() {
        return this.TagLength;
    }

    public short GetRSSI() {
        return this.m_rssi;
    }

    public CAENRFIDLogicalSource GetSource() {
        return this.LogicalSource;
    }

    public CAENRFIDProtocol GetType() {
        return this.proto;
    }

    public Date GetTimeStamp() {
        return this.TimeStamp;
    }

    public String GetAntenna() {
        return this.TReadPoint;
    }

    public byte[] GetXPC() {
        return this.XPC;
    }

    public byte[] GetPC() {
        return this.PC;
    }

    public float GetPhaseBegin() {
        return this.phaseBegin;
    }

    public float GetPhaseEnd() {
        return this.phaseEnd;
    }

    public long GetFrequency() {
        return this.frequency;
    }

    public String GetReadPoint() throws CAENRFIDException {
        if (this.TReadPoint.equals("")) {
            throw new CAENRFIDException("@ ReadPoint not available");
        }
        return this.TReadPoint;
    }

    public short getSubCommandCode() {
        return this.subcmd_code;
    }

    public short getSubCommandResultCode() {
        return this.subcmd_resultcode;
    }

    public byte[] getSubcommandData() {
        return this.subcmd_data;
    }

    public static enum MemBanks {
        RESERVED(0),
        EPC(1),
        TID(2),
        USER(3);

        private int code;

        private MemBanks(int c) {
            this.code = c;
        }

        public int getBankNum() {
            return this.code;
        }
    }
}

